/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;

public class NettyHttp2RequestReadyCallback
implements HttpResponseReadyCallback {
    private final ChannelHandlerContext ctx;
    private final Http2HeadersFrame headersFrame;

    public NettyHttp2RequestReadyCallback(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
        this.ctx = ctx;
        this.headersFrame = headersFrame;
    }

    public void responseReady(HttpResponse response, ResponseStatusCallback responseStatusCallback) {
        try {
            this.sendResponse(this.ctx, this.headersFrame.stream(), response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Writer startResponse(HttpResponse response, ResponseStatusCallback responseStatusCallback, Charset encoding) {
        return null;
    }

    private void sendResponse(ChannelHandlerContext ctx, Http2FrameStream stream, HttpResponse response) throws IOException {
        ByteBuf content = ctx.alloc().buffer();
        InputStream contentAsInputStream = response.getEntity().getContent();
        content.writeBytes(contentAsInputStream, contentAsInputStream.available());
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)String.valueOf(response.getStatusCode()));
        ctx.write((Object)new DefaultHttp2HeadersFrame(headers, false).stream(stream));
        ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(content, true).stream(stream));
    }
}

