/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.utils.TestUtils;
import org.mule.service.http.netty.utils.server.HardcodedResponseTcpServer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ClientHeaderCaseSensitivityTestCase
extends AbstractMuleTestCase {
    private HttpClient client;
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public HardcodedResponseTcpServer server = new HardcodedResponseTcpServer(this.serverPort.getNumber());

    @Before
    public void setUp() {
        this.client = NettyHttpClient.builder().build();
        this.client.start();
        this.server.setResponse("HTTP/1.1 200 OK\nContent-Length: 0\nHeaderWithCase: HeaderValue\n\n");
    }

    @Test
    public void responseHeaderDoesntLoseCaseWhenPropertyIsSet() {
        TestUtils.preservingHeaderCase(() -> {
            HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder((boolean)HttpServerProperties.PRESERVE_HEADER_CASE).uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
            HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)response.getHeaders().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Content-Length", "HeaderWithCase"}));
        });
    }

    @Test
    public void responseHeaderLoseCaseWhenPropertyIsNotSet() throws ExecutionException, InterruptedException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder((boolean)HttpServerProperties.PRESERVE_HEADER_CASE).uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)response.getHeaders().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"content-length", "headerwithcase"}));
    }

    @Test
    public void requestHeaderDoesNotLoseCaseWhenPropertyIsSet() {
        TestUtils.preservingHeaderCase(() -> {
            HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder((boolean)HttpServerProperties.PRESERVE_HEADER_CASE).uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("GET").addHeader("HeaderWithCase", "HeaderValue")).entity((HttpEntity)new EmptyHttpEntity())).build();
            HttpResponse ignored = (HttpResponse)this.client.sendAsync(httpRequest).get();
            List<String> rawRequests = this.server.getReceivedRawRequests();
            MatcherAssert.assertThat(rawRequests, (Matcher)Matchers.hasSize((int)1));
            String rawRequest = rawRequests.get(0);
            MatcherAssert.assertThat((Object)rawRequest, (Matcher)Matchers.containsString((String)"HeaderWithCase"));
        });
    }

    @Test
    public void requestHeaderLoseCaseWhenPropertyIsNotSet() throws ExecutionException, InterruptedException {
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder((boolean)HttpServerProperties.PRESERVE_HEADER_CASE).uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("GET").addHeader("HeaderWithCase", "HeaderValue")).entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse ignored = (HttpResponse)this.client.sendAsync(httpRequest).get();
        List<String> rawRequests = this.server.getReceivedRawRequests();
        MatcherAssert.assertThat(rawRequests, (Matcher)Matchers.hasSize((int)1));
        String rawRequest = rawRequests.get(0);
        MatcherAssert.assertThat((Object)rawRequest, (Matcher)Matchers.containsString((String)"headerwithcase"));
    }
}

