/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.service.http.netty.impl.client.auth.AuthHeaderFactory;
import org.mule.service.http.netty.impl.client.auth.AuthUtils;
import org.mule.service.http.netty.impl.client.auth.Realm;

public class DigestAuthMessageFactory
implements AuthHeaderFactory {
    private final String username;
    private final String password;
    private final Realm realm;
    private final URI uri;
    private final String methodName;
    private Status status;

    public DigestAuthMessageFactory(String username, String password, URI uri, String methodName) {
        this.username = username;
        this.password = password;
        this.realm = new Realm(username, password, uri);
        this.uri = uri;
        this.methodName = methodName;
        this.status = Status.NOT_STARTED;
    }

    @Override
    public boolean hasFinished() {
        return Status.FINISHED == this.status;
    }

    @Override
    public String getNextHeader(String wwwAuthenticateHeader) {
        switch (this.status) {
            case NOT_STARTED: {
                this.status = Status.WAITING_FOR_CHALLENGE;
                return this.computeDigestHeader(wwwAuthenticateHeader);
            }
            case WAITING_FOR_CHALLENGE: {
                this.status = Status.FINISHED;
                if (wwwAuthenticateHeader != null) {
                    return this.computeDigestHeader(wwwAuthenticateHeader);
                }
                return null;
            }
            case FINISHED: {
                return null;
            }
        }
        throw new IllegalStateException("Unknown state: " + this.status);
    }

    private String computeDigestHeader(String wwwAuthHeader) {
        Realm reqRealm = StringUtils.isBlank((CharSequence)wwwAuthHeader) ? Realm.newRealm(this.realm, this.uri, this.methodName) : this.buildRealmFromAuthHeader(wwwAuthHeader, this.uri, this.methodName);
        String realmUri = AuthUtils.computeRealmURI(this.uri, false, false);
        StringBuilder builder = new StringBuilder().append("Digest ");
        builder.append(String.format("username=\"%s\",", this.username));
        builder.append(String.format("realm=\"%s\",", reqRealm.getRealmName()));
        builder.append(String.format("nonce=\"%s\",", reqRealm.getNonce()));
        builder.append(String.format("uri=\"%s\",", realmUri));
        if (!StringUtils.isBlank((CharSequence)this.realm.getAlgorithm())) {
            builder.append(String.format("algorithm=\"%s\",", reqRealm.getAlgorithm()));
        }
        builder.append(String.format("response=\"%s\",", reqRealm.getResponse()));
        if (reqRealm.getOpaque() != null) {
            builder.append(String.format("opaque=\"%s\",", reqRealm.getOpaque()));
        }
        if (reqRealm.getQop() != null) {
            builder.append(String.format("qop=\"%s\",", reqRealm.getQop()));
            builder.append(String.format("nc=\"%s\",", reqRealm.getNc()));
            builder.append(String.format("cnonce=\"%s\",", reqRealm.getCnonce()));
        }
        String digestStringWithTrailingComma = builder.toString();
        return digestStringWithTrailingComma.substring(0, digestStringWithTrailingComma.length() - 2);
    }

    public Realm buildRealmFromAuthHeader(String headerLine, URI uri, String methodName) {
        String rawQop;
        String realmName = DigestAuthMessageFactory.getTokenValue(headerLine, "realm");
        String nonce = DigestAuthMessageFactory.getTokenValue(headerLine, "nonce");
        String opaque = DigestAuthMessageFactory.getTokenValue(headerLine, "opaque");
        String scheme = StringUtils.isBlank((CharSequence)nonce) ? HttpAuthenticationType.BASIC.name() : HttpAuthenticationType.DIGEST.name();
        String algorithm = null;
        if (!StringUtils.isBlank((CharSequence)nonce)) {
            algorithm = DigestAuthMessageFactory.getTokenValue(headerLine, "algorithm");
        }
        String qop = rawQop = DigestAuthMessageFactory.getTokenValue(headerLine, "qop");
        if (rawQop != null) {
            qop = DigestAuthMessageFactory.parseQop(rawQop);
        }
        return Realm.newRealm(this.realm, realmName, nonce, qop, opaque, algorithm, uri, methodName);
    }

    private static String getTokenValue(String headerLine, String token) {
        if (headerLine == null) {
            return null;
        }
        int match = headerLine.indexOf(token);
        if (match <= 0) {
            return null;
        }
        int trailingComa = headerLine.indexOf(44, match += token.length() + 1);
        String value = headerLine.substring(match, trailingComa > 0 ? trailingComa : headerLine.length());
        value = value.length() > 0 && value.charAt(value.length() - 1) == '\"' ? value.substring(0, value.length() - 1) : value;
        return value.charAt(0) == '\"' ? value.substring(1) : value;
    }

    private static String parseQop(String rawQop) {
        String[] rawServerSupportedQops = rawQop.split(",");
        String[] serverSupportedQops = new String[rawServerSupportedQops.length];
        for (int i = 0; i < rawServerSupportedQops.length; ++i) {
            serverSupportedQops[i] = rawServerSupportedQops[i].trim();
        }
        for (String qop : serverSupportedQops) {
            if (!"auth".equals(qop)) continue;
            return qop;
        }
        for (String qop : serverSupportedQops) {
            if (!"auth-int".equals(qop)) continue;
            return qop;
        }
        return null;
    }

    static enum Status {
        NOT_STARTED,
        WAITING_FOR_CHALLENGE,
        FINISHED;

    }
}

