/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.utils.server;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpInputOverHTTP;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.security.Constraint;
import org.junit.rules.ExternalResource;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.service.http.netty.utils.NtlmLoginAuthenticator;

public class AuthenticationTestServer
extends ExternalResource {
    public int httpPort;
    public static final String DEFAULT_RESPONSE = "{\"key1\":\"value1\",\"key2\":\"value2\"}";
    protected volatile Server server;
    protected volatile String method;
    protected volatile String uri;
    protected volatile Multimap<String, String> headers = Multimaps.newMultimap((Map)new CaseInsensitiveMapWrapper(), Sets::newHashSet);
    protected volatile String body;

    public AuthenticationTestServer(int port) {
        this.httpPort = port;
    }

    public void before() throws Exception {
        this.server = this.createServer();
        TestHandler handler = new TestHandler();
        String realmPath = FileUtils.getResourcePath((String)"auth/realm.properties", ((Object)((Object)this)).getClass());
        this.server.setHandler((Handler)this.createAuthHandler(this.server, handler, realmPath));
        this.server.start();
    }

    private AbstractHandler createAuthHandler(Server server, AbstractHandler handler, String realmPath) {
        HashLoginService loginService = new HashLoginService("TestRealm", realmPath);
        server.addBean((Object)loginService);
        ContextHandler basicContext = this.createBasicContextHandler(handler);
        ContextHandler digestContext = this.createDigestContextHandler(handler);
        ContextHandler ntlmContext = this.createNtlmContextHandler(handler);
        ContextHandler multiAuthContext = this.createMultiAuthContextHandler(handler);
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        handlers.setHandlers(new Handler[]{basicContext, digestContext, ntlmContext, multiAuthContext});
        return handlers;
    }

    private ContextHandler createDigestContextHandler(AbstractHandler handler) {
        Constraint digestConstraint = new Constraint();
        digestConstraint.setName("auth");
        digestConstraint.setRoles(new String[]{"user"});
        digestConstraint.setAuthenticate(true);
        ConstraintMapping digestConstraintMapping = new ConstraintMapping();
        digestConstraintMapping.setConstraint(digestConstraint);
        digestConstraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler digestSecurityHandler = new ConstraintSecurityHandler();
        digestSecurityHandler.setAuthenticator((Authenticator)new DigestAuthenticator());
        digestSecurityHandler.setConstraintMappings(new ConstraintMapping[]{digestConstraintMapping});
        digestSecurityHandler.setHandler((Handler)handler);
        ContextHandler digestContext = new ContextHandler("/digest");
        digestContext.setHandler((Handler)digestSecurityHandler);
        return digestContext;
    }

    protected ContextHandler createBasicContextHandler(AbstractHandler handler) {
        Constraint basicConstraint = new Constraint();
        basicConstraint.setName("auth");
        basicConstraint.setRoles(new String[]{"user"});
        basicConstraint.setAuthenticate(true);
        ConstraintMapping basicConstraintMapping = new ConstraintMapping();
        basicConstraintMapping.setConstraint(basicConstraint);
        basicConstraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler basicSecurityHandler = new ConstraintSecurityHandler();
        basicSecurityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        basicSecurityHandler.setConstraintMappings(new ConstraintMapping[]{basicConstraintMapping});
        basicSecurityHandler.setHandler((Handler)handler);
        ContextHandler basicContext = new ContextHandler("/basic");
        basicContext.setHandler((Handler)basicSecurityHandler);
        return basicContext;
    }

    private ContextHandler createNtlmContextHandler(AbstractHandler handler) {
        Constraint ntlmConstraint = new Constraint();
        ntlmConstraint.setName("auth");
        ntlmConstraint.setRoles(new String[]{"user"});
        ntlmConstraint.setAuthenticate(true);
        ConstraintMapping ntlmConstraintMapping = new ConstraintMapping();
        ntlmConstraintMapping.setConstraint(ntlmConstraint);
        ntlmConstraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler ntlmSecurityHandler = new ConstraintSecurityHandler();
        ntlmSecurityHandler.setAuthenticator((Authenticator)new NtlmLoginAuthenticator());
        ntlmSecurityHandler.setConstraintMappings(new ConstraintMapping[]{ntlmConstraintMapping});
        ntlmSecurityHandler.setHandler((Handler)handler);
        ContextHandler ntlmContext = new ContextHandler("/ntlm");
        ntlmContext.setHandler((Handler)ntlmSecurityHandler);
        return ntlmContext;
    }

    private ContextHandler createMultiAuthContextHandler(final AbstractHandler handler) {
        Constraint basicConstraint = new Constraint();
        basicConstraint.setName("basicAuth");
        basicConstraint.setRoles(new String[]{"user"});
        basicConstraint.setAuthenticate(true);
        ConstraintMapping basicConstraintMapping = new ConstraintMapping();
        basicConstraintMapping.setConstraint(basicConstraint);
        basicConstraintMapping.setPathSpec("/multi-auth/*");
        ConstraintSecurityHandler basicSecurityHandler = new ConstraintSecurityHandler();
        basicSecurityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        basicSecurityHandler.setConstraintMappings(new ConstraintMapping[]{basicConstraintMapping});
        Constraint digestConstraint = new Constraint();
        digestConstraint.setName("digestAuth");
        digestConstraint.setRoles(new String[]{"user"});
        digestConstraint.setAuthenticate(true);
        ConstraintMapping digestConstraintMapping = new ConstraintMapping();
        digestConstraintMapping.setConstraint(digestConstraint);
        digestConstraintMapping.setPathSpec("/multi-auth/*");
        ConstraintSecurityHandler digestSecurityHandler = new ConstraintSecurityHandler();
        digestSecurityHandler.setAuthenticator((Authenticator)new DigestAuthenticator());
        digestSecurityHandler.setConstraintMappings(new ConstraintMapping[]{digestConstraintMapping});
        Constraint ntlmConstraint = new Constraint();
        ntlmConstraint.setName("ntlmAuth");
        ntlmConstraint.setRoles(new String[]{"user"});
        ntlmConstraint.setAuthenticate(true);
        ConstraintMapping ntlmConstraintMapping = new ConstraintMapping();
        ntlmConstraintMapping.setConstraint(ntlmConstraint);
        ntlmConstraintMapping.setPathSpec("/multi-auth/*");
        ConstraintSecurityHandler ntlmSecurityHandler = new ConstraintSecurityHandler();
        ntlmSecurityHandler.setAuthenticator((Authenticator)new NtlmLoginAuthenticator());
        ntlmSecurityHandler.setConstraintMappings(new ConstraintMapping[]{ntlmConstraintMapping});
        final ContextHandlerCollection securityHandlers = new ContextHandlerCollection();
        securityHandlers.setHandlers(new Handler[]{basicSecurityHandler, digestSecurityHandler, ntlmSecurityHandler});
        ContextHandler multiAuthContext = new ContextHandler("/multi-auth");
        multiAuthContext.setHandler((Handler)securityHandlers);
        multiAuthContext.setHandler((Handler)new ContextHandlerCollection(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                securityHandlers.handle(target, baseRequest, request, response);
                if (!baseRequest.isHandled()) {
                    handler.handle(target, baseRequest, request, response);
                }
            }
        });
        return multiAuthContext;
    }

    public void after() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Server createServer() {
        return new Server(this.httpPort);
    }

    public void addHandler(AbstractHandler handler) {
        this.server.setHandler((Handler)handler);
    }

    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.extractBaseRequestParts(baseRequest);
        if (!this.isAuthenticated(request)) {
            response.addHeader("WWW-Authenticate", "Basic realm=\"Test\"");
            response.addHeader("WWW-Authenticate", "NTLM");
            response.addHeader("WWW-Authenticate", "Digest realm=\"Test\", qop=\"auth\", nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\", opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"");
            response.setStatus(401);
        } else {
            this.writeResponse(response);
        }
    }

    private boolean isAuthenticated(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Digest ")) {
            String[] params = authHeader.substring("Digest ".length()).split(",\\s*");
            String username = Arrays.stream(params).filter(param -> param.startsWith("username=")).findFirst().map(param -> param.split("=")[1].replace("\"", "").trim()).orElse(null);
            return username.equals("testUsername");
        }
        if (authHeader != null && authHeader.startsWith("NTLM")) {
            return true;
        }
        if (authHeader != null && authHeader.startsWith("Basic ")) {
            String base64Credentials = authHeader.substring("Basic ".length()).trim();
            String credentials = new String(Base64.getDecoder().decode(base64Credentials));
            String[] values = credentials.split(":", 2);
            String username = values[0];
            String password = values[1];
            return "testUsername".equals(username) && "testPassword".equals(password);
        }
        return false;
    }

    protected void extractBaseRequestParts(Request baseRequest) throws IOException {
        this.method = baseRequest.getMethod();
        this.uri = baseRequest.getHttpURI().getPathQuery();
        this.extractHeadersFromBaseRequest(baseRequest);
        HttpInputOverHTTP inputStream = (HttpInputOverHTTP)baseRequest.getInputStream();
        StringBuffer buffer = new StringBuffer();
        while (!inputStream.isFinished()) {
            int toRead = inputStream.available();
            byte[] bytes = new byte[toRead];
            int bytesRead = inputStream.read(bytes);
            if (bytesRead <= 0) continue;
            buffer.append(new String(bytes));
        }
        this.body = buffer.toString();
    }

    protected void extractHeadersFromBaseRequest(Request baseRequest) {
        for (String headerName : this.getHeaderNames(baseRequest)) {
            Enumeration headerValues = baseRequest.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                this.headers.put((Object)headerName, (Object)((String)headerValues.nextElement()));
            }
        }
    }

    protected void writeResponse(HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setStatus(200);
        response.getWriter().print(DEFAULT_RESPONSE);
    }

    private List<String> getHeaderNames(Request baseRequest) {
        Enumeration headerNames = baseRequest.getHeaderNames();
        ArrayList<String> headerList = new ArrayList<String>();
        while (headerNames.hasMoreElements()) {
            headerList.add((String)headerNames.nextElement());
        }
        return headerList;
    }

    public String getRequestBody() {
        return this.body;
    }

    private class TestHandler
    extends AbstractHandler {
        private TestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            AuthenticationTestServer.this.handleRequest(baseRequest, request, response);
            baseRequest.setHandled(true);
        }
    }
}

