/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.message.BaseHttp2Response;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.util.NoOpResponseStatusCallback;
import org.mule.service.http.netty.utils.TcpTextClient;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.Eventually;
import org.mule.tck.junit4.rule.DynamicPort;

@Issue(value="W-15867731")
public class ServerGracefulShutdownTestCase
extends AbstractMuleTestCase {
    private static final ExecutorService executorService = Executors.newFixedThreadPool(1);
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private HttpServer httpServer;
    private HttpListenerRegistry listenerRegistry;
    private NettyHttpClient httpClient;
    private final Latch requestHandlerStartedLatch = new Latch();
    private final Latch requestHandlerCanContinue = new Latch();
    private long shutdownTimeoutMillis = 50000000000L;

    private Long getShutdownTimeout() {
        return this.shutdownTimeoutMillis;
    }

    @Before
    public void setup() throws Exception {
        this.listenerRegistry = new HttpListenerRegistry();
        this.httpServer = NettyHttpServer.builder().withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(this.listenerRegistry).withShutdownTimeout(this::getShutdownTimeout).withClientChannelHandler(new AcceptedConnectionChannelInitializer(this.listenerRegistry, true, 30000, 10000L, null, 300)).build();
        this.httpServer.start();
        this.httpServer.addRequestHandler("/with-latch", (requestContext, responseCallback) -> {
            this.requestHandlerStartedLatch.release();
            try {
                this.requestHandlerCanContinue.await();
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Latch await unexpectedly interrupted");
            }
            responseCallback.responseReady((HttpResponse)new BaseHttp2Response(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity("Test body")), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        });
        this.httpServer.addRequestHandler("/without-latch", (requestContext, responseCallback) -> responseCallback.responseReady((HttpResponse)new BaseHttp2Response(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity("Test body")), (ResponseStatusCallback)new NoOpResponseStatusCallback()));
        this.httpClient = NettyHttpClient.builder().withUsingPersistentConnections(true).build();
        this.httpClient.start();
    }

    @After
    public void tearDown() {
        this.httpClient.stop();
        if (!this.httpServer.isStopped()) {
            this.httpServer.stop();
        }
        this.httpServer.dispose();
    }

    @Test
    public void cannotCreateHttpServerWithoutShutdownTimeout() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> NettyHttpServer.builder().withServerAddress(new InetSocketAddress(this.serverPort.getNumber())).withHttpListenerRegistry(this.listenerRegistry).build());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Shutdown timeout Supplier can't be null"));
    }

    @Test
    public void whenStoppingTheServerInTheMiddleOfARequestItEndsWithoutIssues() throws InterruptedException, ExecutionException {
        HttpRequest request = HttpRequest.builder().protocol(HttpProtocol.HTTP_1_1).method("GET").uri(String.format("http://localhost:%d/with-latch", this.serverPort.getNumber())).build();
        CompletableFuture future = this.httpClient.sendAsync(request);
        this.requestHandlerStartedLatch.await();
        executorService.submit(() -> ((HttpServer)this.httpServer).stop());
        this.requestHandlerCanContinue.release();
        HttpResponse httpResponse = (HttpResponse)future.get();
        String bodyAsString = IOUtils.toString((InputStream)httpResponse.getEntity().getContent());
        MatcherAssert.assertThat((Object)bodyAsString, (Matcher)Matchers.containsString((String)"Test body"));
    }

    @Test
    public void canReuseAPersistentConnectionWhileStopping() throws IOException {
        try (TcpTextClient tcpTextClient = new TcpTextClient("localhost", this.serverPort.getNumber());){
            tcpTextClient.sendString("GET /without-latch HTTP/1.1\r\nHost: localhost:" + this.serverPort.getNumber() + "\r\n\r\n");
            MatcherAssert.assertThat((Object)tcpTextClient.receiveUntil("\r\n\r\n"), (Matcher)Matchers.containsString((String)"content-length: 9"));
            MatcherAssert.assertThat((Object)tcpTextClient.receive(9), (Matcher)Matchers.containsString((String)"Test body"));
            executorService.submit(() -> ((HttpServer)this.httpServer).stop());
            MatcherAssert.assertThat((Object)this.httpServer, (Matcher)Matchers.is((Matcher)Eventually.eventually(this.stopping())));
            tcpTextClient.sendString("GET /without-latch HTTP/1.1\r\nHost: localhost:" + this.serverPort.getNumber() + "\r\n\r\n");
            MatcherAssert.assertThat((Object)tcpTextClient.receiveUntil("\r\n\r\n"), (Matcher)Matchers.containsString((String)"content-length: 9"));
            MatcherAssert.assertThat((Object)tcpTextClient.receive(9), (Matcher)Matchers.containsString((String)"Test body"));
            MatcherAssert.assertThat((Object)this.httpServer, (Matcher)Matchers.is(this.stopping()));
        }
        MatcherAssert.assertThat((Object)this.httpServer, (Matcher)Matchers.is((Matcher)Eventually.eventually(this.stopped())));
    }

    @Test
    public void stopOperationFinishesWithConnectionsInflightIfTheTimeoutIsElapsed() throws IOException {
        this.shutdownTimeoutMillis = 100L;
        try (TcpTextClient tcpTextClient = new TcpTextClient("localhost", this.serverPort.getNumber());){
            tcpTextClient.sendString("GET /without-latch HTTP/1.1\r\nHost: localhost:" + this.serverPort.getNumber() + "\r\n\r\n");
            MatcherAssert.assertThat((Object)tcpTextClient.receiveUntil("\r\n\r\n"), (Matcher)Matchers.containsString((String)"content-length: 9"));
            MatcherAssert.assertThat((Object)tcpTextClient.receive(9), (Matcher)Matchers.containsString((String)"Test body"));
            this.httpServer.stop();
            MatcherAssert.assertThat((Object)this.httpServer, (Matcher)Matchers.is((Matcher)Eventually.eventually(this.stopped())));
            MatcherAssert.assertThat((Object)tcpTextClient.receive(1), (Matcher)Matchers.is((Matcher)Matchers.emptyString()));
        }
    }

    private Matcher<HttpServer> stopped() {
        return new TypeSafeMatcher<HttpServer>(){

            public void describeTo(Description description) {
                description.appendText("Server is not stopped");
            }

            public boolean matchesSafely(HttpServer httpServer) {
                return httpServer.isStopped();
            }
        };
    }

    private Matcher<HttpServer> stopping() {
        return new TypeSafeMatcher<HttpServer>(){

            public void describeTo(Description description) {
                description.appendText("Server is not stopping");
            }

            public boolean matchesSafely(HttpServer httpServer) {
                return httpServer.isStopping();
            }
        };
    }
}

