/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.service;

import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.netty.impl.client.HttpClientConnectionManager;
import org.mule.service.http.netty.impl.server.HttpServerConnectionManager;
import org.mule.service.http.netty.impl.server.util.DefaultRequestMatcherRegistryBuilder;
import org.mule.service.http.netty.impl.service.ContextHttpClientFactory;
import org.mule.service.http.netty.impl.service.ContextHttpServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpServiceImplementation
implements HttpService,
Startable,
Stoppable {
    private final HttpServerConnectionManager serverConnectionManager;
    private final HttpClientConnectionManager clientConnectionManager;
    private static final Logger logger;

    public NettyHttpServiceImplementation(SchedulerService schedulerService) {
        this(schedulerService, new HttpServerConnectionManager(schedulerService), new HttpClientConnectionManager(schedulerService));
    }

    protected NettyHttpServiceImplementation(SchedulerService schedulerService, HttpServerConnectionManager serverConnectionManager, HttpClientConnectionManager clientConnectionManager) {
        this.serverConnectionManager = serverConnectionManager;
        this.clientConnectionManager = clientConnectionManager;
    }

    public HttpServerFactory getServerFactory() {
        return new ContextHttpServerFactory(this.serverConnectionManager, () -> 1000L);
    }

    @Inject
    public HttpServerFactory getServerFactory(MuleConfiguration muleConfiguration) {
        return new ContextHttpServerFactory(this.serverConnectionManager, () -> ((MuleConfiguration)muleConfiguration).getShutdownTimeout());
    }

    public HttpClientFactory getClientFactory() {
        return new ContextHttpClientFactory(this.clientConnectionManager);
    }

    public RequestMatcherRegistry.RequestMatcherRegistryBuilder getRequestMatcherRegistryBuilder() {
        return new DefaultRequestMatcherRegistryBuilder();
    }

    public String getName() {
        return "HTTP Service using Netty";
    }

    public void start() throws MuleException {
        LifecycleUtils.initialiseIfNeeded((Object)this.serverConnectionManager);
        LifecycleUtils.initialiseIfNeeded((Object)this.clientConnectionManager);
    }

    public void stop() throws MuleException {
        LifecycleUtils.disposeIfNeeded((Object)this.serverConnectionManager, (Logger)logger);
        LifecycleUtils.disposeIfNeeded((Object)this.clientConnectionManager, (Logger)logger);
    }

    static {
        System.setProperty("io.netty.handler.codec.http.defaultStrictLineParsing", "false");
        logger = LoggerFactory.getLogger(NettyHttpServiceImplementation.class);
    }
}

