/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.service.http.netty.impl.client.ReactorNettyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExpectContinueHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientExpectContinueHandler.class);
    private static final int CHUNK_SIZE = 8192;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            LOGGER.debug("Received response: {}", (Object)response);
            if (response.status().code() == 100) {
                LOGGER.info("Received 100 Continue response");
                HttpEntity requestEntity = (HttpEntity)ctx.channel().attr(ReactorNettyClient.REQUEST_ENTITY_KEY).get();
                if (requestEntity != null) {
                    this.streamEntityToChannel(ctx, requestEntity);
                    LOGGER.debug("Streaming request entity payload to channel");
                } else {
                    LOGGER.warn("No request entity found for 100 Continue response");
                }
            } else {
                LOGGER.debug("Received non-100 response: {}", (Object)response.status().code());
                super.channelRead(ctx, msg);
            }
        } else {
            LOGGER.warn("Received unexpected message type: {}", (Object)msg.getClass().getName());
            super.channelRead(ctx, msg);
        }
    }

    private void streamEntityToChannel(ChannelHandlerContext ctx, HttpEntity requestEntity) {
        try (InputStream inputStream = requestEntity.getContent();){
            int bytesRead;
            if (inputStream == null) {
                LOGGER.error("InputStream is null");
                throw new IOException("InputStream is null");
            }
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ByteBuf chunk = Unpooled.wrappedBuffer((byte[])buffer, (int)0, (int)bytesRead);
                ctx.write((Object)chunk);
            }
            ctx.flush();
            LOGGER.debug("Successfully streamed HttpEntity in chunks");
        }
        catch (IOException e) {
            LOGGER.error("Failed to read content from HttpEntity: {}", (Object)e.getMessage());
            throw new RuntimeException("Error reading HttpEntity content", e);
        }
    }
}

