/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.tx;

import org.mule.runtime.api.tx.TransactionException;
import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * Base contract for a component which can participate in a transaction
 *
 * @since 1.0
 */
@MinMuleVersion("4.4.0")
public interface Transactional {

  /**
   * Begins the transaction
   *
   * @throws TransactionException if the transaction fails to begin
   */
  void begin() throws TransactionException;

  /**
   * Commits the transaction
   *
   * @throws TransactionException if the transaction fails to commit
   */
  void commit() throws TransactionException;

  /**
   * Rolls the transaction back
   *
   * @throws TransactionException if the transaction fails to roll back
   */
  void rollback() throws TransactionException;
}
