/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.semantics.connectivity;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Signals that the annotated component should not be considered while generating a Connectivity Schema.
 * <p>
 * This annotations is meant to be used on Connection Providers and parameters defined as part of those.
 *
 * @since 1.0
 */
@Target({FIELD, TYPE})
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.4")
@DoNotEnforceMinMuleVersion
public @interface ExcludeFromConnectivitySchema {
}
