/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.semantics.connectivity;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Indicates that the annotated class models the configuration of a generic Proxy
 * <p/>
 * This annotation is to be used on parameters which model a statically typed object (pojos or statically typed json, xml, etc).
 * <p>
 * For NTLM proxies use {@link ConfiguresNtlmProxy} instead
 *
 * @see ConfiguresNtlmProxy
 * @since 1.0
 */
@Target(TYPE)
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.4")
@DoNotEnforceMinMuleVersion
public @interface ConfiguresProxy {
}
