/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.notification;

import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.notification.NotificationActionDefinition;

import java.util.Set;

/**
 * A component responsible for providing an immutable {@link Set} of {@link NotificationActionDefinition}s.
 *
 * @since 1.0
 * @see Fires
 * @see NotificationActionDefinition
 */
@MinMuleVersion("4.5.0")
@DoNotEnforceMinMuleVersion
public interface NotificationActionProvider {

  /**
   * @return a {@link Set} of {@link NotificationActionDefinition}.
   */
  Set<NotificationActionDefinition> getNotificationActions();

}
