/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.ra;

import com.mulesoft.adapter.ra.CCIConnectionRequestInfo;
import com.mulesoft.adapter.ra.XITrace;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class XISecurityUtilities {
    private static final XITrace TRACE = new XITrace(XISecurityUtilities.class.getName());

    public static PasswordCredential getPasswordCredential(final ManagedConnectionFactory mcf, final Subject subject, ConnectionRequestInfo info) throws ResourceException {
        String SIGNATURE = "getPasswordCredential(final ManagedConnectionFactory mcf, final Subject subject, ConnectionRequestInfo info)";
        TRACE.entering("getPasswordCredential(final ManagedConnectionFactory mcf, final Subject subject, ConnectionRequestInfo info)", new Object[]{mcf, subject, info});
        PasswordCredential credential = null;
        if (subject == null) {
            if (info == null) {
                credential = null;
            } else {
                CCIConnectionRequestInfo myinfo = (CCIConnectionRequestInfo)info;
                credential = new PasswordCredential(myinfo.getUserName(), myinfo.getPassword().toCharArray());
                credential.setManagedConnectionFactory(mcf);
            }
        } else {
            credential = AccessController.doPrivileged(new PrivilegedAction<PasswordCredential>(){

                @Override
                public PasswordCredential run() {
                    Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
                    for (PasswordCredential temp : creds) {
                        if (!temp.getManagedConnectionFactory().equals(mcf)) continue;
                        return temp;
                    }
                    return null;
                }
            });
            if (credential == null) {
                throw new SecurityException("No PasswordCredential found");
            }
        }
        TRACE.exiting("getPasswordCredential(final ManagedConnectionFactory mcf, final Subject subject, ConnectionRequestInfo info)");
        return credential;
    }

    public static boolean isEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean isPasswordCredentialEqual(PasswordCredential a, PasswordCredential b) {
        String SIGNATURE = "isPasswordCredentialEqual(PasswordCredential a, PasswordCredential b)";
        TRACE.entering("isPasswordCredentialEqual(PasswordCredential a, PasswordCredential b)", new Object[]{a, b});
        boolean equal = false;
        if (a == b) {
            equal = true;
        } else if (a == null && b != null) {
            equal = false;
        } else if (a != null && b == null) {
            equal = false;
        } else if (!XISecurityUtilities.isEqual(a.getUserName(), b.getUserName())) {
            equal = false;
        } else {
            String p1 = null;
            String p2 = null;
            if (a.getPassword() != null) {
                p1 = new String(a.getPassword());
            }
            if (b.getPassword() != null) {
                p2 = new String(b.getPassword());
            }
            equal = XISecurityUtilities.isEqual(p1, p2);
        }
        TRACE.exiting("isPasswordCredentialEqual(PasswordCredential a, PasswordCredential b)");
        return equal;
    }
}

