/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.ra;

import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.helper.PILogger;
import com.mulesoft.adapter.module.PIModule;
import com.mulesoft.adapter.module.salesforce.SalesforcePIModule;
import com.mulesoft.adapter.module.salesforce.TransportConfigurator;
import com.mulesoft.adapter.ra.CCIConnection;
import com.mulesoft.adapter.ra.SPIManagedConnectionFactory;
import com.mulesoft.adapter.ra.SPIManagedConnectionMetaData;
import com.mulesoft.adapter.ra.XIAdapterCategories;
import com.mulesoft.adapter.ra.XIConnectionEventListenerManager;
import com.mulesoft.adapter.ra.XISecurityUtilities;
import com.mulesoft.adapter.ra.XITrace;
import com.sap.aii.af.service.cpa.Channel;
import com.sap.engine.interfaces.messaging.api.Message;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class SPIManagedConnection
implements ManagedConnection,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final XITrace TRACE = new XITrace(SPIManagedConnection.class.getName());
    private XIConnectionEventListenerManager cciListener;
    private PasswordCredential credential;
    private SPIManagedConnectionFactory mcf;
    private PrintWriter logWriter;
    private boolean supportsLocalTx;
    private boolean destroyed;
    private Set<CCIConnection> connectionSet;
    private String channelID = null;
    private Channel channel = null;
    private boolean asmaGet = false;
    private boolean asmaError = false;
    private PIModule module;

    SPIManagedConnection(SPIManagedConnectionFactory managedConnectionFactory, PasswordCredential credential, boolean supportsLocalTx, String channelID, Channel channel) throws ResourceException, NotSupportedException {
        String SIGNATURE = "SpiManagedConnection(ManagedConnectionFactory mcf, PasswordCredential credential, boolean supportsLocalTx, String channelID)";
        TRACE.entering("SpiManagedConnection(ManagedConnectionFactory mcf, PasswordCredential credential, boolean supportsLocalTx, String channelID)", new Object[]{managedConnectionFactory, credential, supportsLocalTx, channelID});
        if (supportsLocalTx) {
            throw new NotSupportedException("Local transactions are not supported!");
        }
        this.mcf = managedConnectionFactory;
        this.credential = credential;
        this.supportsLocalTx = supportsLocalTx;
        this.channelID = channelID;
        this.channel = channel;
        this.connectionSet = new HashSet<CCIConnection>();
        this.cciListener = new XIConnectionEventListenerManager(this);
        new TransportConfigurator().configureNetweaverHttpTransport();
        try {
            this.module = new SalesforcePIModule(this.channel);
        }
        catch (ResourceException e) {
            TRACE.catching("SpiManagedConnection(ManagedConnectionFactory mcf, PasswordCredential credential, boolean supportsLocalTx, String channelID)", e);
            TRACE.warningT("SpiManagedConnection(ManagedConnectionFactory mcf, PasswordCredential credential, boolean supportsLocalTx, String channelID)", XIAdapterCategories.CONNECT_EIS, "Exception during PIModule creation. Reason: {0}", new Object[]{e.getMessage()});
            TRACE.throwing("SpiManagedConnection(ManagedConnectionFactory mcf, PasswordCredential credential, boolean supportsLocalTx, String channelID)", e);
            throw e;
        }
        TRACE.exiting("SpiManagedConnection(ManagedConnectionFactory mcf, PasswordCredential credential, boolean supportsLocalTx, String channelID)");
    }

    public IPILogger createLogger(Message message) {
        return new PILogger(this.channel, message);
    }

    public final PIModule getModule() {
        return this.module;
    }

    boolean getAsmaGet() {
        return this.asmaGet;
    }

    boolean getAsmaError() {
        return this.asmaError;
    }

    String getChannelID() {
        return this.channelID;
    }

    public void setSupportsLocalTx(boolean ltx) throws NotSupportedException {
        if (ltx) {
            throw new NotSupportedException("Local transactions are not supported!");
        }
        this.supportsLocalTx = ltx;
    }

    public boolean getSupportsLocalTx() {
        return this.supportsLocalTx;
    }

    public void setManagedConnectionFactory(SPIManagedConnectionFactory mcf) {
        this.mcf = mcf;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        String SIGNATURE = "getConnection(Subject subject, ConnectionRequestInfo info)";
        TRACE.entering("getConnection(Subject subject, ConnectionRequestInfo info)", new Object[]{subject, info});
        PasswordCredential newCredential = XISecurityUtilities.getPasswordCredential(this.mcf, subject, info);
        if (!XISecurityUtilities.isPasswordCredentialEqual(newCredential, this.credential)) {
            throw new SecurityException("Principal does not match.Reauthentication not supported");
        }
        this.checkIfDestroyed();
        CCIConnection cciConnection = new CCIConnection(this);
        this.addCciConnection(cciConnection);
        TRACE.exiting("getConnection(Subject subject, ConnectionRequestInfo info)");
        return cciConnection;
    }

    public void destroy() throws ResourceException {
        String SIGNATURE = "destroy()";
        TRACE.entering("destroy()");
        this.destroy(false);
        TRACE.exiting("destroy()");
    }

    void destroy(boolean fromMCF) throws ResourceException {
        String SIGNATURE = "destroy(boolean fromMCF)";
        TRACE.entering("destroy(boolean fromMCF)", new Object[]{fromMCF});
        if (!this.destroyed) {
            try {
                this.destroyed = true;
                this.invalidateAllConnections();
                this.module.dispose();
                this.module = null;
            }
            catch (Exception ex) {
                TRACE.catching("destroy(boolean fromMCF)", ex);
                throw new ResourceException(ex.getMessage());
            }
        }
        if (!fromMCF) {
            this.mcf.removeManagedConnection(this.channelID);
        }
        TRACE.exiting("destroy(boolean fromMCF)");
    }

    public void cleanup() throws ResourceException {
        String SIGNATURE = "cleanup()";
        TRACE.entering("cleanup()");
        try {
            this.checkIfDestroyed();
            this.invalidateAllConnections();
        }
        catch (Exception ex) {
            TRACE.catching("cleanup()", ex);
            throw new ResourceException(ex.getMessage());
        }
        TRACE.exiting("cleanup()");
    }

    private void invalidateAllConnections() {
        for (CCIConnection cciCon : this.connectionSet) {
            cciCon.invalidate();
        }
        this.connectionSet.clear();
    }

    public void associateConnection(Object connection) throws ResourceException {
        String SIGNATURE = "associateConnection(Object connection)";
        TRACE.entering("associateConnection(Object connection)");
        this.checkIfDestroyed();
        if (!(connection instanceof CCIConnection)) {
            IllegalStateException ise = new IllegalStateException("Invalid connection object: " + connection);
            TRACE.throwing("associateConnection(Object connection)", ise);
            throw ise;
        }
        CCIConnection cciCon = (CCIConnection)connection;
        cciCon.associateConnection(this);
        TRACE.exiting("associateConnection(Object connection)");
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        String SIGNATURE = "addConnectionEventListener(ConnectionEventListener listener)";
        TRACE.entering("addConnectionEventListener(ConnectionEventListener listener)");
        this.cciListener.addConnectorListener(listener);
        TRACE.exiting("addConnectionEventListener(ConnectionEventListener listener)");
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        String SIGNATURE = "removeConnectionEventListener(ConnectionEventListener listener)";
        TRACE.entering("removeConnectionEventListener(ConnectionEventListener listener)");
        this.cciListener.removeConnectorListener(listener);
        TRACE.exiting("removeConnectionEventListener(ConnectionEventListener listener)");
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("XA transaction not supported");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("Local transaction not supported");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new SPIManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        String SIGNATURE = "setLogWriter(PrintWriter out)";
        TRACE.entering("setLogWriter(PrintWriter out)", new Object[]{out});
        this.logWriter = out;
        out.print("XI AF Sample Adapter has received a J2EE container log writer.");
        out.print("XI AF Sample Adapter will not use the J2EE container log writer. See the trace file for details.");
        TRACE.exiting("setLogWriter(PrintWriter out)");
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    PasswordCredential getPasswordCredential() {
        return this.credential;
    }

    public void sendEvent(int eventType, Exception ex) {
        this.cciListener.sendEvent(eventType, ex, null);
    }

    public void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        this.cciListener.sendEvent(eventType, ex, connectionHandle);
    }

    public void addCciConnection(CCIConnection cciCon) {
        this.connectionSet.add(cciCon);
    }

    public void removeCciConnection(CCIConnection cciCon) {
        this.connectionSet.remove(cciCon);
    }

    public void start() throws ResourceException {
        this.mcf.startMCF();
    }

    public void stop() throws ResourceException {
        this.mcf.stopMCF();
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new javax.resource.spi.IllegalStateException("Managed connection is closed");
        }
    }
}

