/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.ra;

import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.ra.CCIConnection;
import com.mulesoft.adapter.ra.SPIManagedConnection;
import com.mulesoft.adapter.ra.SPIManagedConnectionFactory;
import com.mulesoft.adapter.ra.XIAdapterCategories;
import com.mulesoft.adapter.ra.XIInteractionSpecImpl;
import com.mulesoft.adapter.ra.XIMessageRecordImpl;
import com.mulesoft.adapter.ra.XITrace;
import com.sap.aii.af.lib.ra.cci.XIInteraction;
import com.sap.aii.af.lib.ra.cci.XIInteractionSpec;
import com.sap.aii.af.lib.ra.cci.XIMessageRecord;
import com.sap.engine.interfaces.messaging.api.Message;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;

public class CCIInteraction
implements XIInteraction {
    private static final XITrace TRACE = new XITrace(CCIInteraction.class.getName());
    private Connection connection;
    private SPIManagedConnection mc = null;
    private SPIManagedConnectionFactory mcf = null;

    public CCIInteraction(Connection cciConnection) throws ResourceException {
        String SIGNATURE = "CciInteraction(javax.resource.cci.Connection)";
        TRACE.entering("CciInteraction(javax.resource.cci.Connection)", new Object[]{cciConnection});
        if (cciConnection == null) {
            ResourceException re = new ResourceException("No related CCI connection in Interaction (cciConnection is null).");
            TRACE.throwing("CciInteraction(javax.resource.cci.Connection)", re);
            throw re;
        }
        this.connection = cciConnection;
        this.mc = ((CCIConnection)this.connection).getManagedConnection();
        if (this.mc == null) {
            ResourceException re = new ResourceException("No related managed connection in CCI connection (mc is null).");
            TRACE.throwing("CciInteraction(javax.resource.cci.Connection)", re);
            throw re;
        }
        this.mcf = (SPIManagedConnectionFactory)this.mc.getManagedConnectionFactory();
        if (this.mcf == null) {
            ResourceException re = new ResourceException("No related managed connection factory in managed connection (mcf is null).");
            TRACE.throwing("CciInteraction(javax.resource.cci.Connection)", re);
            throw re;
        }
        TRACE.exiting("CciInteraction(javax.resource.cci.Connection)");
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void close() throws ResourceException {
        String SIGNATURE = "close()";
        TRACE.entering("close()");
        this.connection = null;
        TRACE.exiting("close()");
    }

    public boolean execute(InteractionSpec ispec, Record input, Record output) throws ResourceException {
        String SIGNATURE = "execute(InteractionSpec ispec, Record input, Record output)";
        TRACE.entering("execute(InteractionSpec ispec, Record input, Record output)");
        if (!(output instanceof XIMessageRecord)) {
            ResourceException re = new ResourceException("Output record is no XI AF XIMessageRecord.");
            TRACE.throwing("execute(InteractionSpec ispec, Record input, Record output)", re);
            throw re;
        }
        XIMessageRecord callerOutput = (XIMessageRecord)output;
        XIMessageRecord localOutput = (XIMessageRecord)this.execute(ispec, input);
        try {
            callerOutput.setXIMessage(localOutput.getXIMessage());
            callerOutput.setRecordName(localOutput.getRecordName());
            callerOutput.setRecordShortDescription(localOutput.getRecordShortDescription());
        }
        catch (Exception e) {
            TRACE.catching("execute(InteractionSpec ispec, Record input, Record output)", e);
            TRACE.errorT("execute(InteractionSpec ispec, Record input, Record output)", XIAdapterCategories.CONNECT, "SOA.apt_sample.0002", "Exception during output record transfer. Reason: {0}", e.getMessage());
            ResourceException re = new ResourceException("Output record cannot be filled. Reason: " + e.getMessage());
            TRACE.throwing("execute(InteractionSpec ispec, Record input, Record output)", re);
            throw re;
        }
        TRACE.exiting("execute(InteractionSpec ispec, Record input, Record output)");
        return true;
    }

    public Record execute(InteractionSpec ispec, Record input) throws ResourceException {
        String SIGNATURE = "execute(InteractionSpec ispec, Record input)";
        TRACE.entering("execute(InteractionSpec ispec, Record input)", new Object[]{ispec, input});
        if (ispec == null) {
            ResourceException re = new ResourceException("Input ispec is null.");
            TRACE.throwing("execute(InteractionSpec ispec, Record input)", re);
            throw re;
        }
        if (!(ispec instanceof XIInteractionSpec)) {
            ResourceException re = new ResourceException("Input ispec is no XI AF InteractionSpec.");
            TRACE.throwing("execute(InteractionSpec ispec, Record input)", re);
            throw re;
        }
        try {
            XIMessageRecordImpl messageRecord = (XIMessageRecordImpl)input;
            Message xiMessage = messageRecord.getXIMessage();
            IPILogger logger = this.mc.createLogger(xiMessage);
            return this.mc.getModule().execute(ispec, messageRecord, logger);
        }
        catch (ResourceException e) {
            TRACE.warningT("execute(InteractionSpec ispec, Record input)", XIAdapterCategories.CONNECT_EIS, "Exception during PIModule execution. Reason: {0}", new Object[]{e.getMessage()});
            TRACE.throwing("execute(InteractionSpec ispec, Record input)", e);
            throw e;
        }
    }

    public ResourceWarning getWarnings() throws ResourceException {
        return null;
    }

    public void clearWarnings() throws ResourceException {
    }

    public XIInteractionSpec getXIInteractionSpec() throws NotSupportedException {
        return new XIInteractionSpecImpl();
    }
}

