/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module.salesforce;

import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.Error;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SalesForceDeleteErrorMessage {
    private final List<DeleteResult> results;
    private final StringBuilder errorMessage = new StringBuilder();

    public SalesForceDeleteErrorMessage(List<DeleteResult> results) {
        this.results = results;
    }

    public String errorMessage() {
        if (this.results == null) {
            return "";
        }
        this.appendNewLine();
        for (DeleteResult result : this.results) {
            this.appendErrorsFrom(result);
        }
        return this.errorMessage.toString();
    }

    protected final void appendNewLine() {
        if (this.errorMessage.length() > 0) {
            this.errorMessage.append(System.getProperty("line.separator"));
        }
    }

    private void appendErrorsFrom(DeleteResult saveResult) {
        if (saveResult.isSuccess()) {
            return;
        }
        for (Error error : saveResult.getErrors()) {
            this.errorMessage.append(error.getStatusCode());
            this.errorMessage.append(": ");
            this.errorMessage.append(error.getMessage());
        }
    }

    public final boolean isSuccess() {
        if (this.results == null) {
            return true;
        }
        for (DeleteResult result : this.results) {
            if (result.isSuccess()) continue;
            return false;
        }
        return true;
    }
}

