/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module.salesforce;

import com.mulesoft.adapter.helper.XML;
import com.mulesoft.adapter.module.salesforce.SObjectTypeFinder;
import com.sforce.ws.bind.TypeInfo;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.parser.XmlOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.api.MuleException;
import org.mule.tools.module.invocation.DynamicModule;
import org.mule.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SObjects {
    private static final String SALESFORCE_ENTERPRISE_NAMESPACE = "urn:enterprise.soap.sforce.com";
    private static final String OBJECTS_NAMESPACE = "sObjects";
    static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final TypeMapper TYPE_MAPPER = new TypeMapper();

    private SObjects() {
    }

    public static String extractType(Node node, Map<String, String> attributes) {
        if (node.hasAttributes()) {
            NamedNodeMap nodeAttributes = node.getAttributes();
            for (int i = 0; i < nodeAttributes.getLength(); ++i) {
                Node nodeAttribute = nodeAttributes.item(i);
                if (!TYPE_ATTRIBUTE_NAME.equals(XML.stripNamespaceIfNecessary(nodeAttribute.getNodeName()))) continue;
                return XML.stripNamespaceIfNecessary(nodeAttribute.getNodeValue());
            }
        }
        return attributes.remove(TYPE_ATTRIBUTE_NAME);
    }

    public static Map<String, List<Map<String, String>>> parse(Document payload) {
        HashMap<String, List<Map<String, String>>> typedObjects = new HashMap<String, List<Map<String, String>>>();
        List<Node> sObjectNodes = SObjects.findSObjectRootNodes(payload);
        for (Node rootNode : sObjectNodes) {
            Map<String, String> attributes;
            String type = SObjects.extractType(rootNode, attributes = SObjects.extractSObjectAttributes(rootNode));
            if (type == null) {
                throw new IllegalArgumentException("Cannot access type attribute");
            }
            SObjects.addObjects(type, typedObjects, attributes);
        }
        return typedObjects;
    }

    private static void addObjects(String type, Map<String, List<Map<String, String>>> typedObjects, Map<String, String> attributes) {
        List<Map<String, String>> objectsOfType = typedObjects.get(type);
        if (objectsOfType == null) {
            objectsOfType = new ArrayList<Map<String, String>>();
            typedObjects.put(type, objectsOfType);
        }
        objectsOfType.add(attributes);
    }

    private static Map<String, String> extractSObjectAttributes(Node rootNode) {
        NodeList attributeNodes = rootNode.getChildNodes();
        int attributeNodesLength = attributeNodes.getLength();
        HashMap<String, String> attributes = new HashMap<String, String>(attributeNodesLength);
        for (int i = 0; i < attributeNodesLength; ++i) {
            Node node = attributeNodes.item(i);
            String key = XML.stripNamespaceIfNecessary(node.getNodeName());
            attributes.put(key, node.getTextContent());
        }
        return attributes;
    }

    private static void generate(String tagname, XmlOutputStream outputStream, Map<String, Object> object) throws IOException {
        outputStream.writeStartTag("", tagname);
        String type = (String)object.remove(TYPE_ATTRIBUTE_NAME);
        if (type != null) {
            outputStream.writeAttribute("", "xsi:type", "sf:" + type);
        }
        outputStream.writeAttribute("", "xmlns:sf", "urn:sobject.enterprise.soap.sforce.com");
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            String tagName = entry.getKey();
            TypeInfo info = new TypeInfo("", "sf:" + tagName, "", "", 1, 1, true);
            TYPE_MAPPER.writeObject(outputStream, info, entry.getValue(), true);
        }
        outputStream.writeEndTag("", tagname);
    }

    public static byte[] generateQueryResponse(List<Map<String, Object>> objects, String rootElementName, String rootElementNamespace) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XmlOutputStream xmlOutputStream = new XmlOutputStream((OutputStream)outputStream, false);
            xmlOutputStream.startDocument();
            xmlOutputStream.writeStartTag(rootElementNamespace, rootElementName);
            if (!StringUtils.isEmpty((String)rootElementNamespace)) {
                xmlOutputStream.writeAttribute("", "xmlns", SALESFORCE_ENTERPRISE_NAMESPACE);
            }
            xmlOutputStream.writeAttribute("", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xmlOutputStream.writeStartTag("", "result");
            xmlOutputStream.writeStartTag("", "done");
            xmlOutputStream.writeText("true");
            xmlOutputStream.writeEndTag("", "done");
            xmlOutputStream.writeStartTag("", "queryLocator");
            xmlOutputStream.writeEndTag("", "queryLocator");
            for (Map<String, Object> object : objects) {
                SObjects.generate("records", xmlOutputStream, object);
            }
            xmlOutputStream.writeStartTag("", "size");
            xmlOutputStream.writeText(Integer.toString(objects.size()));
            xmlOutputStream.writeEndTag("", "size");
            xmlOutputStream.writeEndTag("", "result");
            xmlOutputStream.writeEndTag(rootElementNamespace, rootElementName);
            xmlOutputStream.endDocument();
            xmlOutputStream.close();
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IO-Error when constructing XML from sObject-list");
        }
    }

    public static byte[] generateSubscriptionResponse(Map<String, Object> object, String rootElementName, String rootElementNamespace, String channel, String createdDate, String type) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XmlOutputStream xmlOutputStream = new XmlOutputStream((OutputStream)outputStream, false);
            xmlOutputStream.startDocument();
            xmlOutputStream.writeStartTag(rootElementNamespace, rootElementName);
            if (!StringUtils.isEmpty((String)rootElementNamespace)) {
                xmlOutputStream.writeAttribute("", "xmlns", SALESFORCE_ENTERPRISE_NAMESPACE);
            }
            xmlOutputStream.writeAttribute("", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xmlOutputStream.writeStringElement(SALESFORCE_ENTERPRISE_NAMESPACE, "channel", channel);
            xmlOutputStream.writeStringElement(SALESFORCE_ENTERPRISE_NAMESPACE, "createdDate", createdDate);
            xmlOutputStream.writeStringElement(SALESFORCE_ENTERPRISE_NAMESPACE, TYPE_ATTRIBUTE_NAME, type);
            SObjects.generate(OBJECTS_NAMESPACE, xmlOutputStream, object);
            xmlOutputStream.writeEndTag(rootElementNamespace, rootElementName);
            xmlOutputStream.endDocument();
            xmlOutputStream.close();
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IO-Error when constructing XML from sObject-list");
        }
    }

    public static List<Node> findSObjectRootNodes(Document document) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node firstChild = document.getFirstChild();
        NodeList children = firstChild.getChildNodes();
        int childNodesLength = children.getLength();
        for (int i = 0; i < childNodesLength; ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().endsWith(OBJECTS_NAMESPACE)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static List<Map<String, Object>> asTypedObject(DynamicModule module, String type, List<Map<String, String>> objects) throws MuleException {
        ArrayList<Map<String, Object>> typedObjects = new ArrayList<Map<String, Object>>(objects.size());
        SObjectTypeFinder typeFinder = new SObjectTypeFinder(type, module);
        typeFinder.init();
        for (Map<String, String> object : objects) {
            HashMap<String, Object> typedObject = new HashMap<String, Object>();
            for (Map.Entry<String, String> attributeEntry : object.entrySet()) {
                String attributeName = attributeEntry.getKey();
                String attributeType = typeFinder.findField(attributeName).getType().name();
                Object value = TYPE_MAPPER.deserialize(attributeEntry.getValue(), new QName("http://www.w3.org/2001/XMLSchema", attributeType));
                typedObject.put(attributeName, value);
            }
            typedObjects.add(typedObject);
        }
        return typedObjects;
    }
}

