/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module.salesforce;

import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.helper.XML;
import com.mulesoft.adapter.module.AbstractOperationHandler;
import com.mulesoft.adapter.module.PIMessageParameters;
import com.mulesoft.adapter.module.salesforce.SObjects;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditLogStatus;
import java.util.HashMap;
import java.util.List;
import javax.resource.ResourceException;
import org.mule.api.MuleException;
import org.mule.tools.module.invocation.DynamicModule;
import org.mule.util.StringUtils;

public class QueryOperationHandler
extends AbstractOperationHandler {
    private static final String PROCESSOR_NAME = "query";
    private static final String QUERY_PARAMETER_NAME = "query";

    public QueryOperationHandler(DynamicModule module) {
        super("query", module);
    }

    public final byte[] handle(PIMessageParameters messageParameters) throws MuleException, ResourceException {
        List<List<String>> queriesGroups = XML.textNodes(messageParameters.getRequestContent());
        if (queriesGroups.isEmpty()) {
            throw new IllegalArgumentException("No queryGroup identified.");
        }
        if (queriesGroups.size() > 1) {
            throw new IllegalArgumentException("More than a single query group has been sent.");
        }
        String query = queriesGroups.get(0).get(0).trim();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("query", query);
        IPILogger logger = messageParameters.getLogger();
        logger.reportAuditStatus(AuditLogStatus.SUCCESS, "Message contains query \"{0}\"", StringUtils.abbreviate((String)query, (int)250));
        logger.reportProcessingStatus(ProcessState.OK, "invoking query operation", new Object[0]);
        List results = (List)this.invoke(parameters);
        logger.reportProcessingStatus(ProcessState.OK, "invocation finished, query returned {0} results", results.size());
        return SObjects.generateQueryResponse(results, messageParameters.getResponseRootElementName(), messageParameters.getResponseRootElementNamespace());
    }
}

