/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module.salesforce;

import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.helper.XML;
import com.mulesoft.adapter.module.AbstractOperationHandler;
import com.mulesoft.adapter.module.PIMessageParameters;
import com.mulesoft.adapter.module.salesforce.Results;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditLogStatus;
import java.util.HashMap;
import java.util.List;
import javax.resource.ResourceException;
import org.mule.api.MuleException;
import org.mule.tools.module.invocation.DynamicModule;

public class DeleteOperationHandler
extends AbstractOperationHandler {
    private static final String PROCESSOR_NAME = "delete";
    private static final String IDS_PARAMETER_NAME = "ids";

    public DeleteOperationHandler(DynamicModule module) {
        super(PROCESSOR_NAME, module);
    }

    public final byte[] handle(PIMessageParameters messageParameters) throws MuleException, ResourceException {
        List<List<String>> idGroups = XML.textNodes(messageParameters.getRequestContent());
        if (idGroups.isEmpty()) {
            throw new IllegalArgumentException("No delete group identified.");
        }
        if (idGroups.size() > 1) {
            throw new IllegalArgumentException("More than a single delete group has been sent.");
        }
        List<String> ids = idGroups.get(0);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(IDS_PARAMETER_NAME, ids);
        IPILogger logger = messageParameters.getLogger();
        logger.reportAuditStatus(AuditLogStatus.SUCCESS, "deleting ids: {0}", ids);
        logger.reportProcessingStatus(ProcessState.OK, "invoking operation", new Object[0]);
        List results = (List)this.invoke(parameters);
        logger.reportProcessingStatus(ProcessState.OK, "invocation finished", new Object[0]);
        Results.throwIfDeleteNotSuccessful(results);
        return null;
    }
}

