/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module.salesforce;

import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.module.AbstractOperationHandler;
import com.mulesoft.adapter.module.PIMessageParameters;
import com.mulesoft.adapter.module.salesforce.Bulks;
import com.mulesoft.adapter.module.salesforce.Results;
import com.mulesoft.adapter.module.salesforce.SObjects;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditLogStatus;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import org.mule.api.MuleException;
import org.mule.tools.module.invocation.DynamicModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOperationHandler
extends AbstractOperationHandler {
    private static final String PROCESSOR_NAME = "create";
    private static final String BULK_PROCESSOR_NAME = "create-bulk";
    private static final String TYPE_PARAMETER_NAME = "type";
    private static final String OBJECTS_PARAMETER_NAME = "objects";
    private static final int MAX_RECORDS_NUMBER = 200;

    public CreateOperationHandler(DynamicModule module) {
        super(PROCESSOR_NAME, module);
    }

    protected final void create(String type, List<Map<String, Object>> objects, IPILogger logger) throws MuleException, ResourceException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(TYPE_PARAMETER_NAME, type);
        parameters.put(OBJECTS_PARAMETER_NAME, objects);
        logger.reportProcessingStatus(ProcessState.OK, "invoking operation", new Object[0]);
        List results = (List)this.invoke(parameters);
        logger.reportProcessingStatus(ProcessState.OK, "invocation finished", new Object[0]);
        Results.throwIfSaveNotSuccessful(results);
    }

    protected final void createBulk(String type, List<Map<String, String>> objects, IPILogger logger) throws MuleException, ResourceException, InterruptedException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(TYPE_PARAMETER_NAME, type);
        parameters.put(OBJECTS_PARAMETER_NAME, objects);
        logger.reportProcessingStatus(ProcessState.OK, "invoking bulk operation", new Object[0]);
        BatchInfo batchInfo = (BatchInfo)this.invoke(BULK_PROCESSOR_NAME, parameters);
        logger.reportProcessingStatus(ProcessState.OK, "awaiting bulk operation completion", new Object[0]);
        BatchResult batchResult = Bulks.awaitCompletion(this.getModule(), batchInfo);
        logger.reportProcessingStatus(ProcessState.OK, "invocation finished", new Object[0]);
        Bulks.throwIfNotSuccessful(batchResult);
    }

    @Override
    public final byte[] handle(PIMessageParameters messageParameters) throws MuleException, ResourceException {
        Map<String, List<Map<String, String>>> typeObjectsMap = SObjects.parse(messageParameters.getRequestContent());
        if (typeObjectsMap.isEmpty()) {
            throw new IllegalArgumentException("No SObjects identified.");
        }
        if (typeObjectsMap.size() > 1) {
            throw new IllegalArgumentException("More than a single type has been sent.");
        }
        Map.Entry<String, List<Map<String, String>>> entry = typeObjectsMap.entrySet().iterator().next();
        String type = entry.getKey();
        List<Map<String, String>> objects = entry.getValue();
        int size = objects.size();
        IPILogger logger = messageParameters.getLogger();
        logger.reportAuditStatus(AuditLogStatus.SUCCESS, "Message of type {0} contains {1} sObjects", type, size);
        if (size <= 200) {
            List<Map<String, Object>> typedTypeObjectsMap = SObjects.asTypedObject(this.getModule(), type, objects);
            this.create(type, typedTypeObjectsMap, logger);
        } else {
            try {
                this.createBulk(type, objects, logger);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return null;
    }
}

