/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module.salesforce;

import com.sforce.async.BatchInfo;
import com.sforce.async.BatchResult;
import com.sforce.async.Error;
import com.sforce.async.Result;
import java.util.HashMap;
import java.util.LinkedList;
import javax.resource.ResourceException;
import org.mule.api.MuleException;
import org.mule.tools.module.invocation.DynamicModule;

public final class Bulks {
    private static final long CHECK_INTERVAL = 1000L;
    private static final String BATCH_INFO_PROCESSOR_NAME = "batch-info";
    private static final String BATCH_RESULT_PROCESSOR_NAME = "batch-result";
    private static final String BATCH_INFO_PARAMETER_NAME = "batchInfo";

    private Bulks() {
    }

    public static BatchInfo batchInfo(DynamicModule module, BatchInfo batchInfo) throws MuleException {
        HashMap<String, BatchInfo> parameters = new HashMap<String, BatchInfo>();
        parameters.put(BATCH_INFO_PARAMETER_NAME, batchInfo);
        return (BatchInfo)module.invoke(BATCH_INFO_PROCESSOR_NAME, parameters);
    }

    public static BatchResult awaitCompletion(DynamicModule module, BatchInfo batchInfo) throws MuleException, InterruptedException {
        while (true) {
            BatchInfo latestBatchInfo = Bulks.batchInfo(module, batchInfo);
            switch (latestBatchInfo.getState()) {
                case Completed: 
                case Failed: {
                    HashMap<String, BatchInfo> parameters = new HashMap<String, BatchInfo>();
                    parameters.put(BATCH_INFO_PARAMETER_NAME, batchInfo);
                    return (BatchResult)module.invoke(BATCH_RESULT_PROCESSOR_NAME, parameters);
                }
            }
            Thread.sleep(1000L);
        }
    }

    public static void throwIfNotSuccessful(BatchResult batchResult) throws ResourceException {
        LinkedList<Result> failures = new LinkedList<Result>();
        for (Result result : batchResult.getResult()) {
            if (result.isSuccess()) continue;
            failures.add(result);
        }
        if (!failures.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Result failure : failures) {
                builder.append(failure.getId()).append(" {\n");
                for (Error error : failure.getErrors()) {
                    builder.append(error.getStatusCode()).append(":").append(error.getMessage()).append(" ");
                }
                builder.append("}\n");
            }
            throw new ResourceException(builder.toString());
        }
    }
}

