/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module;

import com.mulesoft.adapter.helper.Channels;
import com.mulesoft.adapter.helper.ExceptionHelper;
import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.helper.PILogger;
import com.mulesoft.adapter.helper.Payload;
import com.mulesoft.adapter.module.salesforce.SObjects;
import com.mulesoft.adapter.ra.XIMessageFactoryImpl;
import com.sap.aii.af.lib.mp.module.ModuleData;
import com.sap.aii.af.lib.mp.processor.ModuleProcessor;
import com.sap.aii.af.service.administration.api.cpa.CPAChannelStoppedException;
import com.sap.aii.af.service.administration.api.cpa.CPAFactory;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.aii.af.service.cpa.Binding;
import com.sap.aii.af.service.cpa.CPAException;
import com.sap.aii.af.service.cpa.Channel;
import com.sap.aii.af.service.util.transaction.api.TxManager;
import com.sap.aii.af.service.util.transaction.api.TxManagerException;
import com.sap.aii.af.service.util.transaction.api.TxManagerFactory;
import com.sap.aii.af.service.util.transaction.api.TxTicket;
import com.sap.engine.interfaces.messaging.api.DeliverySemantics;
import com.sap.engine.interfaces.messaging.api.Message;
import com.sap.engine.interfaces.messaging.api.auditlog.AuditLogStatus;
import com.sap.engine.interfaces.messaging.api.exception.InvalidParamException;
import com.sap.engine.interfaces.messaging.api.exception.PayloadFormatException;
import com.sap.tc.logging.Location;
import java.util.Map;
import javax.resource.ResourceException;
import org.mule.api.MuleMessage;
import org.mule.tools.module.invocation.DynamicModule;
import org.mule.util.StringUtils;

public class SubscriptionEventListener
implements DynamicModule.Listener {
    private static final Location LOCATION = Location.getLocation(SubscriptionEventListener.class);
    private final ModuleProcessor moduleProcessor;
    private final Channel channel;
    private final XIMessageFactoryImpl messageFactory;

    public SubscriptionEventListener(XIMessageFactoryImpl messageFactory, Channel channel, ModuleProcessor moduleProcessor) {
        this.messageFactory = messageFactory;
        this.channel = channel;
        this.moduleProcessor = moduleProcessor;
    }

    public void onEvent(MuleMessage event) {
        String signature = "onEvent(final Map<String, Object> event)";
        LOCATION.entering("onEvent(final Map<String, Object> event)", new Object[]{event});
        PILogger logger = new PILogger(this.channel);
        try {
            String channelID = this.channel.getObjectId();
            Message message = this.createPIMessage(channelID);
            logger.setPiMessage(message);
            logger.reportProcessingStatus(ProcessState.OK, "Event received", new Object[0]);
            logger.reportAuditStatus(AuditLogStatus.SUCCESS, "Message created from Salesfoce topic event", new Object[0]);
            this.setDeliverySemantics(message);
            byte[] payload = this.generatePayload(event, logger);
            Payload.populateMessage(message, payload);
            ModuleData moduleData = new ModuleData();
            moduleData.setPrincipalData((Object)message);
            this.sendMessageToModuleProcessor(channelID, moduleData, logger);
        }
        catch (RuntimeException e) {
            LOCATION.catching("onEvent(final Map<String, Object> event)", (Throwable)e);
            logger.reportProcessingStatus(ProcessState.FATAL, "Error when receiving subscribed event: {0}", e.getMessage());
        }
        catch (CPAChannelStoppedException e) {
            LOCATION.catching("onEvent(final Map<String, Object> event)", (Throwable)e);
            logger.reportProcessingStatus(ProcessState.FATAL, "Error when delivering message from subscribed event: {0}", e.getMessage());
        }
        catch (CPAException e) {
            LOCATION.catching("onEvent(final Map<String, Object> event)", (Throwable)e);
            logger.reportProcessingStatus(ProcessState.FATAL, "Can not determine binding for channel for subscribed event: {0}", e.getMessage());
        }
        catch (ResourceException e) {
            LOCATION.catching("onEvent(final Map<String, Object> event)", (Throwable)e);
            logger.reportProcessingStatus(ProcessState.FATAL, "Can not create message for subscribed event: {0}", e.getMessage());
        }
        catch (InvalidParamException e) {
            LOCATION.catching("onEvent(final Map<String, Object> event)", (Throwable)e);
            logger.reportProcessingStatus(ProcessState.FATAL, "Error when receiving subscribed event: {0}", e.getMessage());
        }
        catch (PayloadFormatException e) {
            LOCATION.catching("onEvent(final Map<String, Object> event)", (Throwable)e);
            logger.reportProcessingStatus(ProcessState.FATAL, "Error when receiving subscribed event: {0}", e.getMessage());
        }
        LOCATION.exiting("onEvent(final Map<String, Object> event)");
    }

    protected final byte[] generatePayload(MuleMessage message, IPILogger logger) throws ResourceException {
        String rootElementName = Channels.retrieveSubscriptionResponseRootElementName(this.channel);
        String rootElementNamespace = Channels.retrieveResponseRootElementNamespace(this.channel);
        Map messagePayload = (Map)message.getPayload();
        String inboundChannel = (String)message.getInboundProperty("channel");
        String createdDate = (String)message.getInboundProperty("createdDate");
        String type = (String)message.getInboundProperty("type");
        logger.reportAuditStatus(AuditLogStatus.SUCCESS, "event for type {0} created at {1} received via channel {2}", type, createdDate, inboundChannel);
        return SObjects.generateSubscriptionResponse(messagePayload, rootElementName, rootElementNamespace, inboundChannel, createdDate, type);
    }

    private void sendMessageToModuleProcessor(String channelID, ModuleData moduleData, IPILogger logger) throws ResourceException {
        String signature = "sendMessageToModuleProcessor(final String channelID, final ModuleData moduleData)";
        LOCATION.entering("sendMessageToModuleProcessor(final String channelID, final ModuleData moduleData)", new Object[]{channelID, moduleData});
        TxManager txManager = null;
        TxTicket tx = null;
        try {
            txManager = TxManagerFactory.getInstance().getTxManager();
            tx = txManager.beginTransaction();
            this.moduleProcessor.process(channelID, moduleData);
            txManager.commit(tx);
        }
        catch (TxManagerException e) {
            LOCATION.catching("sendMessageToModuleProcessor(final String channelID, final ModuleData moduleData)", (Throwable)e);
            throw new ResourceException("Cannot commit transaction: " + (Object)((Object)e), (Throwable)e);
        }
        catch (Exception e) {
            LOCATION.catching("sendMessageToModuleProcessor(final String channelID, final ModuleData moduleData)", (Throwable)e);
            if (tx != null && txManager != null) {
                try {
                    txManager.rollback(tx);
                }
                catch (TxManagerException e1) {
                    LOCATION.catching("sendMessageToModuleProcessor(final String channelID, final ModuleData moduleData)", (Throwable)e1);
                    logger.reportProcessingStatus(ProcessState.FATAL, "Cannot roll back transaction: {0}", new Object[]{e1});
                    throw new ResourceException("Cannot roll back transaction: " + (Object)((Object)e1), (Throwable)e1);
                }
            }
            logger.reportProcessingStatus(ProcessState.FATAL, "Cannot send message to module processor: {0}, root cause: {1}", e, ExceptionHelper.extractRootCauseMessage(e));
            throw new ResourceException("Cannot send message to module processor " + e, (Throwable)e);
        }
    }

    protected final Message createPIMessage(String channelID) throws CPAException, ResourceException {
        Binding binding = CPAFactory.getInstance().getLookupManager().getBindingByChannelId(channelID);
        Message message = this.messageFactory.createMessageRecord(binding.getFromParty(), binding.getToParty(), binding.getFromService(), binding.getToService(), binding.getActionName(), binding.getActionNamespace());
        return message;
    }

    protected final void setDeliverySemantics(Message message) throws InvalidParamException, ResourceException {
        DeliverySemantics qualityOfService = Channels.retrieveQualityOfService(this.channel);
        message.setDeliverySemantics(DeliverySemantics.ExactlyOnce);
        if (qualityOfService == DeliverySemantics.ExactlyOnceInOrder) {
            String queueName = Channels.retrieveQueueName(this.channel);
            message.setSequenceId(StringUtils.deleteWhitespace((String)queueName));
        }
    }
}

