/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module;

import com.mulesoft.adapter.helper.ExceptionHelper;
import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.module.PIModule;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import org.mule.retry.policies.SimpleRetryPolicy;

public class DefaultRetryPolicy
extends SimpleRetryPolicy {
    private static final long RETRY_WAIT_TIME = 10000L;
    private static final int RETRY_COUNT = 5;
    private final IPILogger piLogger;
    private final PIModule piModule;

    public DefaultRetryPolicy(PIModule piModule, IPILogger logger) {
        super(10000L, 5);
        this.piModule = piModule;
        this.piLogger = logger;
    }

    protected boolean isApplicableTo(Throwable cause) {
        boolean retryOn = this.piModule.retryOn(cause);
        if (retryOn) {
            this.piLogger.reportProcessingStatus(ProcessState.OK, "Retrying on error: {0}", ExceptionHelper.extractRootCauseMessage(cause));
        } else {
            this.piLogger.reportProcessingStatus(ProcessState.ERROR, "Not retrying on error: {0}", ExceptionHelper.extractRootCauseMessage(cause));
        }
        return retryOn;
    }
}

