/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.module;

import com.mulesoft.adapter.helper.Channels;
import com.mulesoft.adapter.helper.ExceptionHelper;
import com.mulesoft.adapter.helper.IPILogger;
import com.mulesoft.adapter.helper.PILogger;
import com.mulesoft.adapter.helper.Payload;
import com.mulesoft.adapter.helper.XML;
import com.mulesoft.adapter.module.DefaultRetryNotifier;
import com.mulesoft.adapter.module.DefaultRetryPolicy;
import com.mulesoft.adapter.module.OperationHandler;
import com.mulesoft.adapter.module.PIMessageParameters;
import com.mulesoft.adapter.module.PIModule;
import com.mulesoft.adapter.module.SubscriptionEventListener;
import com.mulesoft.adapter.ra.XIMessageFactoryImpl;
import com.mulesoft.adapter.ra.XIMessageRecordImpl;
import com.sap.aii.af.lib.mp.processor.ModuleProcessor;
import com.sap.aii.af.lib.mp.processor.ModuleProcessorException;
import com.sap.aii.af.lib.mp.processor.ModuleProcessorFactory;
import com.sap.aii.af.lib.ra.cci.XIInteractionSpec;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.aii.af.service.cpa.Channel;
import com.sap.engine.interfaces.messaging.api.Message;
import com.sap.engine.interfaces.messaging.api.exception.InvalidParamException;
import com.sap.engine.interfaces.messaging.api.exception.PayloadFormatException;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.retry.RetryPolicy;
import org.mule.retry.policies.AbstractPolicyTemplate;
import org.mule.tools.module.invocation.DynamicModule;
import org.mule.tools.module.invocation.RetryingDynamicModule;
import org.mule.tools.module.model.Module;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPIModule
implements PIModule {
    protected static final Location LOCATION = Location.getLocation((String)AbstractPIModule.class.getPackage().getName());
    private final Channel channel;
    private final DynamicModule module;
    private final Map<String, OperationHandler> operationHandlers = new ConcurrentHashMap<String, OperationHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPIModule(Channel channel) throws ResourceException {
        if (channel == null) {
            throw new IllegalArgumentException("null channel");
        }
        this.channel = channel;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(MuleContext.class.getClassLoader());
        try {
            this.module = this.createConfiguredDynamicModule(channel);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected final Channel getChannel() {
        return this.channel;
    }

    protected final DynamicModule getModule() {
        return this.module;
    }

    protected final DynamicModule createConfiguredDynamicModule(Channel channel) throws ResourceException {
        AbstractPolicyTemplate retryPolicyTemplate = this.createRetryPolicyTemplate();
        PILogger retryLogger = new PILogger(channel);
        retryPolicyTemplate.setNotifier((RetryNotifier)new DefaultRetryNotifier(retryLogger));
        return this.createDynamicModule(this.createModule(channel), this.createParameters(channel), retryPolicyTemplate);
    }

    protected DynamicModule createDynamicModule(Module module, Map<String, Object> parameters, AbstractPolicyTemplate retryPolicyTemplate) throws ResourceException {
        return this.createDefaultDynamicModule(module, parameters, retryPolicyTemplate);
    }

    protected final DynamicModule createDefaultDynamicModule(Module module, Map<String, Object> parameters, AbstractPolicyTemplate retryPolicyTemplate) throws ResourceException {
        return new RetryingDynamicModule(module, parameters, retryPolicyTemplate);
    }

    protected abstract Module createModule(Channel var1) throws ResourceException;

    protected Map<String, Object> createParameters(Channel channel) throws ResourceException {
        return this.createParametersDefault(channel);
    }

    protected Map<String, Object> createParametersDefault(Channel channel) {
        return Collections.emptyMap();
    }

    protected AbstractPolicyTemplate createRetryPolicyTemplate() {
        return new AbstractPolicyTemplate(){

            public RetryPolicy createRetryInstance() {
                PILogger piLogger = new PILogger(AbstractPIModule.this.channel);
                return new DefaultRetryPolicy(AbstractPIModule.this, piLogger);
            }
        };
    }

    protected final OperationHandler getOperationHandler(Message message) throws ResourceException {
        String actionName = message.getAction().getName();
        OperationHandler matchingHandler = this.operationHandlers.get(actionName);
        if (matchingHandler == null) {
            String lowerCaseActionName = actionName.toLowerCase();
            if (lowerCaseActionName.startsWith("create")) {
                return this.operationHandlers.get("create");
            }
            if (lowerCaseActionName.startsWith("upsert")) {
                return this.operationHandlers.get("upsert");
            }
            if (lowerCaseActionName.startsWith("delete")) {
                return this.operationHandlers.get("delete");
            }
            if (lowerCaseActionName.startsWith("query")) {
                return this.operationHandlers.get("query");
            }
            throw new ResourceException("Unsupported operation " + actionName + "; operation names need to start with one of " + this.operationHandlers.keySet());
        }
        return matchingHandler;
    }

    @Override
    public final Record execute(InteractionSpec spec, XIMessageRecordImpl input, IPILogger logger) throws ResourceException {
        String signature = "execute(InteractionSpec ispec, Record input)";
        LOCATION.entering("execute(InteractionSpec ispec, Record input)", new Object[]{spec, input});
        if (spec == null) {
            ResourceException exception = new ResourceException("Input ispec is null.");
            LOCATION.throwing("execute(InteractionSpec ispec, Record input)", (Throwable)exception);
            throw exception;
        }
        XIInteractionSpec interactionSpec = (XIInteractionSpec)spec;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(MuleContext.class.getClassLoader());
        try {
            Message message = input.getXIMessage();
            byte[] payload = this.dispatch(message, logger);
            String functionName = interactionSpec.getFunctionName();
            if ("Send".equals(functionName)) {
                if (payload != null) {
                    LOCATION.warningT("Function name is Send but an output has been generated: <{0}>", new Object[]{payload});
                    logger.reportProcessingStatus(ProcessState.ERROR, "The operation is called asynchronous but has generated a response from Salesforce", new Object[0]);
                }
                Record record = null;
                return record;
            }
            if ("Call".equals(functionName)) {
                if (payload == null) {
                    LOCATION.warningT("Function name is Call but no output has been generated");
                    logger.reportProcessingStatus(ProcessState.ERROR, "The operation is called synchronous but has not generated a response from Salesforce", new Object[0]);
                }
                Record record = this.createOutput(message, payload, logger);
                return record;
            }
            try {
                throw new IllegalArgumentException("Unsupported function name <" + functionName + ">");
            }
            catch (ResourceException e) {
                throw e;
            }
            catch (Exception e) {
                String rootCauseMessage = ExceptionHelper.extractRootCauseMessage(e);
                throw new ResourceException(e.getMessage() + ", root cause is: " + rootCauseMessage, (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
            LOCATION.exiting("execute(InteractionSpec ispec, Record input)");
        }
    }

    @Override
    public boolean retryOn(Throwable cause) {
        return false;
    }

    protected final void register(OperationHandler handler) {
        this.operationHandlers.put(handler.getOperationName(), handler);
    }

    protected final Record createOutput(Message message, byte[] payload, IPILogger logger) throws ResourceException, IOException, InvalidParamException, PayloadFormatException {
        XIMessageRecordImpl output = new XIMessageRecordImpl(message.getToParty(), message.getFromParty(), message.getToService(), message.getFromService(), message.getAction());
        Message responseMessage = output.getXIMessage();
        responseMessage.setRefToMessageId(message.getMessageId());
        logger.setPiMessage(responseMessage);
        if (payload == null) {
            byte[] dummyDocument = XML.emptyDocument();
            logger.reportProcessingStatus(ProcessState.OK, "Sending emty response message", message);
            Payload.populateMessage(responseMessage, dummyDocument);
        } else {
            logger.reportProcessingStatus(ProcessState.OK, "Sending response message", message);
            Payload.populateMessage(responseMessage, payload);
        }
        return output;
    }

    protected byte[] dispatch(Message message, IPILogger logger) throws ResourceException, MuleException, IOException, InvalidParamException, PayloadFormatException, ParserConfigurationException, SAXException {
        OperationHandler operationHandler = this.getOperationHandler(message);
        com.sap.engine.interfaces.messaging.api.Payload mainPayload = message.getMainPayload();
        InputStream mainPayloadInputStream = mainPayload.getInputStream();
        Document document = XML.parse(mainPayloadInputStream);
        LOCATION.debugT("Received XML payload");
        String responseRootElementName = Channels.retrieveQueryResponseRootElementName(this.channel);
        String responseRootElementNamespace = Channels.retrieveResponseRootElementNamespace(this.channel);
        PIMessageParameters messageParameters = new PIMessageParameters(document, responseRootElementName, responseRootElementNamespace, logger);
        return operationHandler.handle(messageParameters);
    }

    protected final void subscribe(String sourceName, Map<String, Object> overridenParameters, XIMessageFactoryImpl messageFactory) throws MuleException, ModuleProcessorException {
        ModuleProcessor moduleProcessor = ModuleProcessorFactory.getModuleProcessor((boolean)true, (int)1, (int)1000);
        this.getModule().subscribe(sourceName, overridenParameters, (DynamicModule.Listener)new SubscriptionEventListener(messageFactory, this.channel, moduleProcessor));
    }

    protected final void unsubscribe(String sourceName) throws MuleException {
        this.getModule().unsubscribe(sourceName);
    }

    @Override
    public void dispose() {
        this.disposeDefault();
    }

    protected final void disposeDefault() {
        this.module.dispose();
    }
}

