/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XML {
    private static final String NAMESPACE_DELIMITER = ":";

    private XML() {
    }

    public static List<List<String>> textNodes(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("null document");
        }
        NodeList rootNodes = document.getChildNodes();
        int rootNodesLength = rootNodes.getLength();
        ArrayList<List<String>> allTextNodes = new ArrayList<List<String>>(rootNodesLength);
        for (int i = 0; i < rootNodesLength; ++i) {
            Node rootNode = rootNodes.item(i);
            if (1 != rootNode.getNodeType()) continue;
            NodeList childNodes = rootNode.getChildNodes();
            int childNodesLength = childNodes.getLength();
            ArrayList<String> textNodes = new ArrayList<String>(childNodesLength);
            for (int j = 0; j < childNodesLength; ++j) {
                Node node = childNodes.item(j);
                if (1 != node.getNodeType()) continue;
                textNodes.add(node.getTextContent());
            }
            if (textNodes.isEmpty()) continue;
            allTextNodes.add(textNodes);
        }
        return allTextNodes;
    }

    public static String firstNamedTextNode(Document document, String tagName) {
        if (document == null) {
            throw new IllegalArgumentException("null document");
        }
        if (tagName == null) {
            throw new IllegalArgumentException("null tagName");
        }
        Element rootElement = document.getDocumentElement();
        NodeList childNodes = rootElement.getChildNodes();
        int childNodesLength = childNodes.getLength();
        for (int j = 0; j < childNodesLength; ++j) {
            Node node = childNodes.item(j);
            String nodeNameWithoutNamespace = XML.stripNamespaceIfNecessary(node.getNodeName());
            if (!tagName.equals(nodeNameWithoutNamespace)) continue;
            return node.getTextContent();
        }
        return null;
    }

    public static String rootTag(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("null document");
        }
        NodeList nodes = document.getChildNodes();
        if (nodes.getLength() <= 0) {
            throw new IllegalArgumentException("Document should have at list one child node.");
        }
        return nodes.item(0).getNodeName();
    }

    public static Document parse(InputStream contentStream) throws ParserConfigurationException, SAXException, IOException {
        if (contentStream == null) {
            throw new IllegalArgumentException("null content");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(contentStream);
    }

    public static String stripNamespaceIfNecessary(String tagName) {
        if (tagName.contains(NAMESPACE_DELIMITER)) {
            return tagName.substring(tagName.indexOf(NAMESPACE_DELIMITER) + 1);
        }
        return tagName;
    }

    public static byte[] emptyDocument() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<empty/>".getBytes();
    }
}

