/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.adapter.helper;

import com.sap.aii.af.service.cpa.Channel;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.core.locking.TechnicalLockException;
import com.sap.engine.services.applocking.LogicalLocking;
import com.sap.engine.services.applocking.LogicalLockingFactory;
import com.sap.tc.logging.Location;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import org.mule.util.StringUtils;

public class TopicListnenerLocking {
    private static final Location LOCATION = Location.getLocation(TopicListnenerLocking.class);
    private static final String LOCK_NAMESPACE = "Mule";
    private static final String LOCK_NAME = "Mule/SalesforceTopic";
    private static final String LOCK_DESCRIPTION = "Mule Adapter lock";
    private final Channel channel;

    public TopicListnenerLocking(Channel channel) {
        this.channel = channel;
    }

    public boolean aquireLock() throws ResourceException {
        boolean ret;
        String SIGNATURE = "aquireLock()";
        LOCATION.entering("aquireLock()");
        LogicalLocking logicalLocking = TopicListnenerLocking.getLocking();
        String argument = this.extractLockArgument();
        try {
            logicalLocking.lock((byte)2, LOCK_NAME, argument, 'X', 10000);
            ret = true;
        }
        catch (LockException le) {
            LOCATION.catching("aquireLock()", (Throwable)le);
            ret = false;
        }
        catch (TechnicalLockException e) {
            LOCATION.catching("aquireLock()", (Throwable)e);
            throw new UnsupportedOperationException("Cannot create logical lock Mule/SalesforceTopic on argument " + argument + ": " + (Object)((Object)e));
        }
        catch (IllegalArgumentException e) {
            LOCATION.catching("aquireLock()", (Throwable)e);
            throw new UnsupportedOperationException("Cannot create logical lock Mule/SalesforceTopic on argument " + argument + ": " + e);
        }
        LOCATION.exiting("aquireLock()", (Object)ret);
        return ret;
    }

    public void unlock() {
        String SIGNATURE = " unlock()";
        LOCATION.entering(" unlock()");
        String argument = this.extractLockArgument();
        LogicalLocking logicalLocking = TopicListnenerLocking.getLocking();
        try {
            logicalLocking.unlock((byte)2, LOCK_NAME, argument, 'X', false);
        }
        catch (TechnicalLockException e) {
            LOCATION.catching(" unlock()", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOCATION.catching(" unlock()", (Throwable)e);
        }
        LOCATION.exiting(" unlock()");
    }

    private String extractLockArgument() {
        return StringUtils.abbreviate((String)this.channel.getObjectId(), (int)150);
    }

    private static LogicalLocking getLocking() {
        String SIGNATURE = "getLocking()";
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(TopicListnenerLocking.class.getClassLoader());
        String lookupName = "applocking";
        try {
            LogicalLocking logicalLocking;
            LogicalLockingFactory factory = (LogicalLockingFactory)new InitialContext().lookup("LogicalLockingFactory");
            LogicalLocking logicalLocking2 = logicalLocking = factory.createLogicalLocking(LOCK_NAMESPACE, LOCK_DESCRIPTION);
            return logicalLocking2;
        }
        catch (NamingException e) {
            LOCATION.catching(SIGNATURE, (Throwable)e);
            throw new RuntimeException("Cannot find applocking in JNDI");
        }
        catch (TechnicalLockException tle) {
            LOCATION.catching(SIGNATURE, (Throwable)tle);
            throw new UnsupportedOperationException("Cannot set up logical locking: " + (Object)((Object)tle));
        }
        catch (IllegalArgumentException iae) {
            LOCATION.catching(SIGNATURE, (Throwable)iae);
            throw new UnsupportedOperationException("Cannot set up logical locking:" + iae);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

