/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.adapter.module.salesforce;

import java.util.List;

import com.sforce.soap.partner.DeleteResult;

/**
 * This class translates a {@link DeleteResult} into a {@link String} that can be used as the
 * error message of an {@link Exception}.
 */
public class SalesForceDeleteErrorMessage {

    private final List<DeleteResult> results;
    private final StringBuilder errorMessage = new StringBuilder();

    public SalesForceDeleteErrorMessage(final List<DeleteResult> results) {
        this.results = results;
    }

    public String errorMessage() {
        if (results == null)
        {
            return "";
        }

        appendNewLine();
        for (DeleteResult result : results) {
            appendErrorsFrom(result);
        }

        return this.errorMessage.toString();
    }

    protected final void appendNewLine() {
        if (this.errorMessage.length() > 0) {
            this.errorMessage.append(System.getProperty("line.separator"));
        }
    }

    private void appendErrorsFrom(final DeleteResult saveResult) {
        if (saveResult.isSuccess()) {
            return;
        }

        for (final com.sforce.soap.partner.Error error : saveResult.getErrors()) {
            this.errorMessage.append(error.getStatusCode());
            this.errorMessage.append(": ");
            this.errorMessage.append(error.getMessage());
        }
    }

    public final boolean isSuccess() {
        if (results == null)
        {
            return true;
        }

        for (final DeleteResult result : this.results) {
            if (!result.isSuccess()) {
                return false;
            }
        }
        return true;
    }
}