/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.adapter.module.salesforce;

import java.util.List;

import javax.resource.ResourceException;

import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;

/**
 * Helper methods for *Result.
 */
public final class Results {

    private Results() {
    }

    /**
     * @param results
     * @throws ResourceException 
     */
    public static void throwIfSaveNotSuccessful(final List<SaveResult> results) throws ResourceException {
        final SalesForceSaveErrorMessage errorMessage = new SalesForceSaveErrorMessage(results);
        if (!errorMessage.isSuccess()) {
            throw new ResourceException(errorMessage.errorMessage());
        }
    }

    /**
     * @param results
     * @throws ResourceException 
     */
    public static void throwIfUpsertNotSuccessful(final List<UpsertResult> results) throws ResourceException {
        final SalesForceUpsertErrorMessage errorMessage = new SalesForceUpsertErrorMessage(results);
        if (!errorMessage.isSuccess()) {
            throw new ResourceException(errorMessage.errorMessage());
        }
    }

    /**
     * @param results
     * @throws ResourceException 
     */
    public static void throwIfDeleteNotSuccessful(final List<DeleteResult> results) throws ResourceException {
        final SalesForceDeleteErrorMessage errorMessage = new SalesForceDeleteErrorMessage(results);
        if (!errorMessage.isSuccess()) {
            throw new ResourceException(errorMessage.errorMessage());
        }
    }

}