package com.mulesoft.adapter.module;

import org.w3c.dom.Document;

import com.mulesoft.adapter.helper.IPILogger;

/**
 * container for request message content, logger and response message properties
 */
public class PIMessageParameters {
    
    private final Document requestContent;
    private final String responseRootElementName;
    private final String responseRootElementNamespace;
    private final IPILogger logger;
    
    public PIMessageParameters(Document requestContent, String responseRootElementName, String responseRootElementNamespace, IPILogger logger) {
        this.logger = logger;
        this.requestContent = requestContent;
        this.responseRootElementName = responseRootElementName;
        this.responseRootElementNamespace = responseRootElementNamespace;
    }

    public IPILogger getLogger() {
        return logger;
    }

    public Document getRequestContent() {
        return requestContent;
    }

    public String getResponseRootElementName() {
        return responseRootElementName;
    }

    public String getResponseRootElementNamespace() {
        return responseRootElementNamespace;
    }

}
