/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.adapter.module;

import javax.resource.ResourceException;

import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;

/**
 * Abstracts operation handling.
 */
public interface OperationHandler {

    /**
     * @return operation name handled
     */
    String getOperationName();

    /**
     * @param messageParameters. PI message content and response parameters.
     * @return a response from provided payload
     * @throws InitialisationException
     * @throws MuleException
     * @throws ResourceException 
     */
    byte[] handle(PIMessageParameters messageParameters) throws MuleException, ResourceException;

}