/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.adapter.module;

import org.mule.retry.policies.SimpleRetryPolicy;

import com.mulesoft.adapter.helper.ExceptionHelper;
import com.mulesoft.adapter.helper.IPILogger;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;

/**
 * Extend {@link SimpleRetryPolicy} by logging retry attempts to {@link IPILogger}.
 */
public class DefaultRetryPolicy extends SimpleRetryPolicy {

    private static final long RETRY_WAIT_TIME = 10000L;
    private static final int RETRY_COUNT = 5;
    private final IPILogger piLogger;
    private final PIModule piModule;

    public DefaultRetryPolicy(final PIModule piModule, final IPILogger logger) {
        super(DefaultRetryPolicy.RETRY_WAIT_TIME, DefaultRetryPolicy.RETRY_COUNT);

        this.piModule = piModule;
        this.piLogger = logger;
    }

    @Override
    protected boolean isApplicableTo(final Throwable cause) {
        final boolean retryOn = this.piModule.retryOn(cause);

        if (retryOn) {
            this.piLogger.reportProcessingStatus(ProcessState.OK, "Retrying on error: {0}", ExceptionHelper.extractRootCauseMessage(cause));
        } else {
            this.piLogger.reportProcessingStatus(ProcessState.ERROR, "Not retrying on error: {0}", ExceptionHelper.extractRootCauseMessage(cause));
        }

        return retryOn;
    }

}