package com.mulesoft.adapter.module;

import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;

import com.mulesoft.adapter.helper.ExceptionHelper;
import com.mulesoft.adapter.helper.IPILogger;
import com.sap.aii.af.service.administration.api.monitoring.ProcessState;
import com.sap.tc.logging.Location;

class DefaultRetryNotifier implements RetryNotifier {

    private final Location location = Location.getLocation(DefaultRetryNotifier.class);
    private final IPILogger logger;

    public DefaultRetryNotifier(final IPILogger logger) {
        this.logger = logger;
    }

    public void onSuccess(final RetryContext context) {
    }

    public void onFailure(final RetryContext context, final Throwable e) {
        this.logger.reportProcessingStatus(ProcessState.FATAL, "Retry failure notification: {0}", ExceptionHelper.extractRootCauseMessage(e));
        
        this.location.traceThrowableT(Location.RUN_TIME_SEVERITY, "Got failure", e);
    }

}