/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.adapter.module;

import java.util.Map;

import org.mule.api.MuleException;
import org.mule.tools.module.invocation.DynamicModule;

/**
 * Base {@link OperationHandler} implementation relying on a {@link DynamicModule} to handle operations.
 */
public abstract class AbstractOperationHandler implements OperationHandler {

    private final String methodName;
    private final DynamicModule module;

    public AbstractOperationHandler(final String methodName, final DynamicModule module) {
        if (methodName == null) {
            throw new IllegalArgumentException("null methodName");
        }
        if (module == null) {
            throw new IllegalArgumentException("null module");
        }

        this.methodName = methodName;
        this.module = module;
    }

    @Override
    public final String getOperationName() {
        return this.methodName;
    }

    protected final DynamicModule getModule() {
        return this.module;
    }

    protected final <T> T invoke(final Map<String, Object> parameters) throws MuleException {
        //Force cast due to http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6302954
        return this.<T>invoke(getOperationName(), parameters);
    }

    protected final <T> T invoke(final String processorName, final Map<String, Object> parameters) throws MuleException {
        //Force cast due to http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6302954
        return getModule().<T>invoke(processorName, parameters);
    }

}