/* (c) 2011-2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.adapter.helper;

import javax.resource.ResourceException;

import com.sap.aii.af.service.cpa.CPAException;
import com.sap.aii.af.service.cpa.Channel;
import com.sap.engine.interfaces.messaging.api.DeliverySemantics;

/**
 * Helper methods for {@link Channel}.
 */
public final class Channels {

    private static final String USERNAME_PARAMETER_NAME = "username";
    private static final String PASSWORD_PARAMETER_NAME = "password";
    private static final String SECURITY_TOKEN_PARAMETER_NAME = "securityToken";
    private static final String QOS_PARAMETER_NAME = "qos";
    private static final String EOIO_SEQUENCEID_PARAMETER_NAME = "qos.eoio.sequenceId";
    private static final String QUERY_RESPONSE_XML_ROOT_ELEMENT_NAME_PARAMETER_NAME = "queryResponseXMLRootElement";
    private static final String SUBSCRIPTION_RESPONSE_XML_ROOT_ELEMENT_NAME_PARAMETER_NAME = "subscriptionResponseXMLRootElement";
    private static final String RESPONSE_XML_ROOT_ELEMENT_NAMESPACE_PARAMETER_NAME = "responseXMLRootElementNS";

    private Channels() {
    }

    /**
     * @param element
     * @return true if specified `element` is defined
     */
    public static boolean isDefined(final String element) {
        return ! "".equals(element);
    }

    /**
     * @param name
     * @param channel
     * @return configuration as a String, "" if undefined
     * @throws ResourceException 
     */
    public static String retrieveConfigurationElement(final String name, final Channel channel) throws ResourceException {
        try {
            return channel.getValueAsString(name);
        }
        catch (CPAException e) {
            throw new ResourceException(e);
        }
    }

    /**
     * @param channel
     * @return username as a String, "" if undefined
     * @throws ResourceException 
     */
    public static String retrieveUsername(final Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(Channels.USERNAME_PARAMETER_NAME, channel);
    }

    /**
     * @param channel
     * @return password as a String, "" if undefined
     * @throws ResourceException 
     */
    public static String retrievePassword(final Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(Channels.PASSWORD_PARAMETER_NAME, channel);
    }

    /**
     * @param channel
     * @return securityToken as a String, "" if undefined
     * @throws ResourceException 
     */
    public static String retrieveSecurityToken(final Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(Channels.SECURITY_TOKEN_PARAMETER_NAME, channel);
    }
    
    /**
     * @param channel
     * @return the QoS
     * @throws ResourceException when invalid QoS was selected
     */
    public static DeliverySemantics retrieveQualityOfService(Channel channel) throws ResourceException {
        String qosValue = Channels.retrieveConfigurationElement(Channels.QOS_PARAMETER_NAME, channel);
        if ("EO".equals(qosValue)) {
            return DeliverySemantics.ExactlyOnce;
        } else if ("EOIO".equals(qosValue)) {
            return DeliverySemantics.ExactlyOnceInOrder;
        } else throw new ResourceException("Unknown QoS: " + qosValue);
    }
    
    public static String retrieveQueueName(Channel channel) throws ResourceException {
       return Channels.retrieveConfigurationElement(Channels.EOIO_SEQUENCEID_PARAMETER_NAME, channel);
    }
    
    public static String retrieveQueryResponseRootElementName(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(Channels.QUERY_RESPONSE_XML_ROOT_ELEMENT_NAME_PARAMETER_NAME, channel);
    }
    
    public static String retrieveSubscriptionResponseRootElementName(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(Channels.SUBSCRIPTION_RESPONSE_XML_ROOT_ELEMENT_NAME_PARAMETER_NAME, channel);
    }
    
    public static String retrieveResponseRootElementNamespace(Channel channel) throws ResourceException {
        return Channels.retrieveConfigurationElement(Channels.RESPONSE_XML_ROOT_ELEMENT_NAMESPACE_PARAMETER_NAME, channel);
    }
    
    
    /**
     * @param name
     * @param channel
     * @return configuration as a int, 0 if undefined
     * @throws ResourceException 
     */
    public static int retrieveConfigurationElementAsInt(final String name, final Channel channel) throws ResourceException {
        try {
            return channel.getValueAsInt(name);
        }
        catch (CPAException e) {
            throw new ResourceException(e);
        }
    }

}