/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.shade.filter.MinijarFilter;
import org.apache.maven.project.MavenProject;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MinijarFilterTest {
    private File emptyFile;

    @Before
    public void init() throws IOException {
        TemporaryFolder tempFolder = new TemporaryFolder();
        tempFolder.create();
        this.emptyFile = tempFolder.newFile();
    }

    @Test
    public void testWithMockProject() throws IOException {
        Assume.assumeFalse((String)"Expected to run under JDK8+", (boolean)System.getProperty("java.version").startsWith("1.7"));
        ArgumentCaptor logCaptor = ArgumentCaptor.forClass(CharSequence.class);
        MavenProject mavenProject = this.mockProject(this.emptyFile);
        Log log = (Log)Mockito.mock(Log.class);
        MinijarFilter mf = new MinijarFilter(mavenProject, log);
        mf.finished();
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).info((CharSequence)logCaptor.capture());
        Assert.assertEquals((Object)"Minimized 0 -> 0", (Object)logCaptor.getValue());
    }

    @Test
    public void testWithPomProject() throws IOException {
        ArgumentCaptor logCaptor = ArgumentCaptor.forClass(CharSequence.class);
        MavenProject mavenProject = this.mockProject(null);
        mavenProject.setPackaging("pom");
        Log log = (Log)Mockito.mock(Log.class);
        MinijarFilter mf = new MinijarFilter(mavenProject, log);
        mf.finished();
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).info((CharSequence)logCaptor.capture());
        ((MavenProject)Mockito.verify((Object)mavenProject, (VerificationMode)Mockito.times((int)0))).getArtifacts();
        Assert.assertEquals((Object)"Minimized 0 -> 0", (Object)logCaptor.getValue());
    }

    private MavenProject mockProject(File file) {
        MavenProject mavenProject = (MavenProject)Mockito.mock(MavenProject.class);
        Artifact artifact = (Artifact)Mockito.mock(Artifact.class);
        Mockito.when((Object)artifact.getGroupId()).thenReturn((Object)"com");
        Mockito.when((Object)artifact.getArtifactId()).thenReturn((Object)"aid");
        Mockito.when((Object)artifact.getVersion()).thenReturn((Object)"1.9");
        Mockito.when((Object)artifact.getClassifier()).thenReturn((Object)"classifier1");
        Mockito.when((Object)artifact.getScope()).thenReturn((Object)"compile");
        Mockito.when((Object)mavenProject.getArtifact()).thenReturn((Object)artifact);
        DefaultArtifact dependencyArtifact = new DefaultArtifact("dep.com", "dep.aid", "1.0", "compile", "jar", "classifier2", null);
        dependencyArtifact.setFile(file);
        TreeSet<DefaultArtifact> artifacts = new TreeSet<DefaultArtifact>();
        artifacts.add(dependencyArtifact);
        Mockito.when((Object)mavenProject.getArtifacts()).thenReturn(artifacts);
        Mockito.when((Object)mavenProject.getArtifact().getFile()).thenReturn((Object)file);
        return mavenProject;
    }

    @Test
    public void finsishedShouldProduceMessageForClassesTotalNonZero() {
        ArgumentCaptor logCaptor = ArgumentCaptor.forClass(CharSequence.class);
        Log log = (Log)Mockito.mock(Log.class);
        MinijarFilter m = new MinijarFilter(1, 50, log);
        m.finished();
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).info((CharSequence)logCaptor.capture());
        Assert.assertEquals((Object)"Minimized 51 -> 1 (1%)", (Object)logCaptor.getValue());
    }

    @Test
    public void finishedShouldProduceMessageForClassesTotalZero() {
        ArgumentCaptor logCaptor = ArgumentCaptor.forClass(CharSequence.class);
        Log log = (Log)Mockito.mock(Log.class);
        MinijarFilter m = new MinijarFilter(0, 0, log);
        m.finished();
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).info((CharSequence)logCaptor.capture());
        Assert.assertEquals((Object)"Minimized 0 -> 0", (Object)logCaptor.getValue());
    }
}

