/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.Shader;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.mojo.ArchiveFilter;
import org.apache.maven.plugins.shade.mojo.ShadeMojo;
import org.apache.maven.plugins.shade.relocation.SimpleRelocator;
import org.apache.maven.plugins.shade.resource.ComponentsXmlResourceTransformer;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.codehaus.plexus.PlexusTestCase;
import org.mockito.Mockito;

public class ShadeMojoTest
extends PlexusTestCase {
    public void testManifestTransformerSelection() throws Exception {
        ShadeMojo mojo = new ShadeMojo();
        Method m = ShadeMojo.class.getDeclaredMethod("toResourceTransformers", String.class, List.class);
        m.setAccessible(true);
        ManifestResourceTransformer defaultTfr = new ManifestResourceTransformer(){

            public String toString() {
                return "default";
            }
        };
        ManifestResourceTransformer testsTfr1 = new ManifestResourceTransformer(){

            public String toString() {
                return "t1";
            }
        };
        testsTfr1.setForShade("tests");
        ManifestResourceTransformer testsTfr2 = new ManifestResourceTransformer(){

            public String toString() {
                return "t2";
            }
        };
        testsTfr2.setForShade("tests");
        ShadeMojoTest.assertEquals(Collections.singletonList(defaultTfr), (Object)m.invoke((Object)mojo, "jar", Arrays.asList(defaultTfr, testsTfr1, testsTfr2)));
        ShadeMojoTest.assertEquals(Arrays.asList(testsTfr1, testsTfr2), (Object)m.invoke((Object)mojo, "tests", Arrays.asList(defaultTfr, testsTfr1, testsTfr2)));
        ShadeMojoTest.assertEquals(Arrays.asList(testsTfr1, testsTfr2), (Object)m.invoke((Object)mojo, "tests", Arrays.asList(testsTfr1, defaultTfr, testsTfr2)));
        ShadeMojoTest.assertEquals(Arrays.asList(testsTfr1, testsTfr2), (Object)m.invoke((Object)mojo, "tests", Arrays.asList(testsTfr1, testsTfr2, defaultTfr)));
    }

    public void testShaderWithDefaultShadedPattern() throws Exception {
        this.shaderWithPattern(null, new File("target/foo-default.jar"));
    }

    public void testShaderWithCustomShadedPattern() throws Exception {
        this.shaderWithPattern("org/shaded/plexus/util", new File("target/foo-custom.jar"));
    }

    public void testShaderWithExclusions() throws Exception {
        File jarFile = new File(ShadeMojoTest.getBasedir(), "target/unit/foo-bar.jar");
        Shader s = (Shader)this.lookup(Shader.ROLE, "default");
        LinkedHashSet<File> set = new LinkedHashSet<File>();
        set.add(new File(ShadeMojoTest.getBasedir(), "src/test/jars/test-artifact-1.0-SNAPSHOT.jar"));
        ArrayList<SimpleRelocator> relocators = new ArrayList<SimpleRelocator>();
        relocators.add(new SimpleRelocator("org.codehaus.plexus.util", "hidden", null, Arrays.asList("org.codehaus.plexus.util.xml.Xpp3Dom", "org.codehaus.plexus.util.xml.pull.*")));
        ArrayList resourceTransformers = new ArrayList();
        ArrayList filters = new ArrayList();
        ShadeRequest shadeRequest = new ShadeRequest();
        shadeRequest.setJars(set);
        shadeRequest.setUberJar(jarFile);
        shadeRequest.setFilters(filters);
        shadeRequest.setRelocators(relocators);
        shadeRequest.setResourceTransformers(resourceTransformers);
        s.shade(shadeRequest);
        try (URLClassLoader cl = new URLClassLoader(new URL[]{jarFile.toURI().toURL()});){
            Class<?> c = cl.loadClass("org.apache.maven.plugins.shade.Lib");
            Field field = c.getDeclaredField("CLASS_REALM_PACKAGE_IMPORT");
            ShadeMojoTest.assertEquals((Object)"org.codehaus.plexus.util.xml.pull", (Object)field.get(null));
            Method method = c.getDeclaredMethod("getClassRealmPackageImport", new Class[0]);
            ShadeMojoTest.assertEquals((Object)"org.codehaus.plexus.util.xml.pull", (Object)method.invoke(null, new Object[0]));
        }
    }

    public void testShadeWithFilter() throws Exception {
        ShadeMojo mojo = new ShadeMojo();
        Field createSourcesJar = ShadeMojo.class.getDeclaredField("createSourcesJar");
        createSourcesJar.setAccessible(true);
        createSourcesJar.set(mojo, Boolean.TRUE);
        ArtifactResolver mockArtifactResolver = new ArtifactResolver(){

            public ArtifactResult resolveArtifact(ProjectBuildingRequest req, final Artifact art) {
                return new ArtifactResult(){

                    public Artifact getArtifact() {
                        art.setResolved(true);
                        String fileName = art.getArtifactId() + "-" + art.getVersion() + (art.getClassifier() != null ? "-" + art.getClassifier() : "") + ".jar";
                        art.setFile(new File(fileName));
                        return art;
                    }
                };
            }

            public ArtifactResult resolveArtifact(ProjectBuildingRequest req, final ArtifactCoordinate coordinate) {
                return new ArtifactResult(){

                    public Artifact getArtifact() {
                        Artifact art = (Artifact)Mockito.mock(Artifact.class);
                        Mockito.when((Object)art.getGroupId()).thenReturn((Object)coordinate.getGroupId());
                        Mockito.when((Object)art.getArtifactId()).thenReturn((Object)coordinate.getArtifactId());
                        Mockito.when((Object)art.getType()).thenReturn((Object)coordinate.getExtension());
                        Mockito.when((Object)art.getClassifier()).thenReturn((Object)coordinate.getClassifier());
                        Mockito.when((Object)art.isResolved()).thenReturn((Object)true);
                        String fileName = coordinate.getArtifactId() + "-" + coordinate.getVersion() + (coordinate.getClassifier() != null ? "-" + coordinate.getClassifier() : "") + ".jar";
                        Mockito.when((Object)art.getFile()).thenReturn((Object)new File(fileName));
                        return art;
                    }
                };
            }
        };
        Field artifactResolverField = ShadeMojo.class.getDeclaredField("artifactResolver");
        artifactResolverField.setAccessible(true);
        artifactResolverField.set(mojo, mockArtifactResolver);
        MavenProject project = new MavenProject();
        ArtifactHandler artifactHandler = (ArtifactHandler)this.lookup(ArtifactHandler.ROLE);
        DefaultArtifact artifact = new DefaultArtifact("org.apache.myfaces.core", "myfaces-impl", VersionRange.createFromVersion((String)"2.0.1-SNAPSHOT"), "compile", "jar", null, artifactHandler);
        artifact = mockArtifactResolver.resolveArtifact(null, (Artifact)artifact).getArtifact();
        project.setArtifact((Artifact)artifact);
        Field projectField = ShadeMojo.class.getDeclaredField("project");
        projectField.setAccessible(true);
        projectField.set(mojo, project);
        ArchiveFilter archiveFilter = new ArchiveFilter();
        Field archiveFilterArtifact = ArchiveFilter.class.getDeclaredField("artifact");
        archiveFilterArtifact.setAccessible(true);
        archiveFilterArtifact.set(archiveFilter, "org.apache.myfaces.core:myfaces-impl");
        Field filtersField = ShadeMojo.class.getDeclaredField("filters");
        filtersField.setAccessible(true);
        filtersField.set(mojo, new ArchiveFilter[]{archiveFilter});
        Field sessionField = ShadeMojo.class.getDeclaredField("session");
        sessionField.setAccessible(true);
        sessionField.set(mojo, Mockito.mock(MavenSession.class));
        Method getFilters = ShadeMojo.class.getDeclaredMethod("getFilters", new Class[0]);
        getFilters.setAccessible(true);
        List filters = (List)getFilters.invoke((Object)mojo, new Object[0]);
        ShadeMojoTest.assertEquals((int)1, (int)filters.size());
        Filter filter = (Filter)filters.get(0);
        ShadeMojoTest.assertTrue((boolean)filter.canFilter(new File("myfaces-impl-2.0.1-SNAPSHOT.jar")));
        ShadeMojoTest.assertTrue((boolean)filter.canFilter(new File("myfaces-impl-2.0.1-SNAPSHOT-sources.jar")));
    }

    public void shaderWithPattern(String shadedPattern, File jar) throws Exception {
        Shader s = (Shader)this.lookup(Shader.ROLE);
        LinkedHashSet<File> set = new LinkedHashSet<File>();
        set.add(new File(ShadeMojoTest.getBasedir(), "src/test/jars/test-project-1.0-SNAPSHOT.jar"));
        set.add(new File(ShadeMojoTest.getBasedir(), "src/test/jars/plexus-utils-1.4.1.jar"));
        ArrayList<SimpleRelocator> relocators = new ArrayList<SimpleRelocator>();
        relocators.add(new SimpleRelocator("org/codehaus/plexus/util", shadedPattern, null, Arrays.asList("org/codehaus/plexus/util/xml/Xpp3Dom", "org/codehaus/plexus/util/xml/pull.*")));
        ArrayList<ComponentsXmlResourceTransformer> resourceTransformers = new ArrayList<ComponentsXmlResourceTransformer>();
        resourceTransformers.add(new ComponentsXmlResourceTransformer());
        ArrayList filters = new ArrayList();
        ShadeRequest shadeRequest = new ShadeRequest();
        shadeRequest.setJars(set);
        shadeRequest.setUberJar(jar);
        shadeRequest.setFilters(filters);
        shadeRequest.setRelocators(relocators);
        shadeRequest.setResourceTransformers(resourceTransformers);
        s.shade(shadeRequest);
    }
}

