/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.maven.loader;

import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.activation.internal.maven.AdditionalPluginDependenciesResolver;
import org.mule.runtime.module.artifact.activation.internal.maven.LightweightDeployableProjectModelBuilder;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

import org.apache.maven.model.Model;

/**
 * Implementation of {@link DeployableProjectModelBuilder} that extends from {@link LightweightDeployableProjectModelBuilder} to
 * configure the {@link MavenReactorResolver} and to set the {@link #pomModels} with the {@link Model} of the current plugin.
 *
 * @since 1.5
 */
public class MavenExtensionDeployableProjectModelBuilder extends LightweightDeployableProjectModelBuilder {

  private final Optional<MavenReactorResolver> mavenReactorResolver;
  private final Map<ArtifactCoordinates, Supplier<MavenPomModel>> pomModels;

  public MavenExtensionDeployableProjectModelBuilder(File projectFolder,
                                                     Optional<MuleDeployableModel> model,
                                                     Optional<MavenReactorResolver> mavenReactorResolver,
                                                     Map<ArtifactCoordinates, Supplier<MavenPomModel>> pomModels) {
    super(projectFolder, model, false);
    this.mavenReactorResolver = mavenReactorResolver;
    this.pomModels = pomModels;
  }

  @Override
  protected Optional<MavenReactorResolver> getMavenReactorResolver() {
    return mavenReactorResolver;
  }

  @Override
  protected AdditionalPluginDependenciesResolver getAdditionalPluginDependenciesResolver(MavenClient mavenClient,
                                                                                         List<AdditionalPluginDependencies> initialAdditionalPluginDependencies) {
    return new AdditionalPluginDependenciesResolver(mavenClient,
                                                    initialAdditionalPluginDependencies,
                                                    new File("temp"),
                                                    pomModels);
  }
}
