/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.maven.documentation.internal.model;

import java.util.LinkedList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * FIXME MDM-57 Remove this class once the Serialized MetadataTypes have all the information in the DescriptionAnnotation. FIXME
 * This class is a copy of the one present in extension-support, and should remain internal in both projects
 *
 * A POJO that represents the extension-descriptions.xml file which contains the necessary annotations and setters necessary to
 * allow JAX-B serialization/deserialization.
 *
 * @since 1.1
 */
@XmlRootElement(name = "extension-documentation")
public class XmlExtensionDocumentation {

  public static final String EXTENSION_DESCRIPTIONS_FILE_RELATIVE_PATH_MASK = "/classes/META-INF/%s-extension-descriptions.xml";

  private XmlExtensionElementDocumentation extension;
  private List<XmlExtensionElementDocumentation> connections = new LinkedList<>();
  private List<XmlExtensionElementDocumentation> configs = new LinkedList<>();
  private List<XmlExtensionElementDocumentation> sources = new LinkedList<>();
  private List<XmlExtensionElementDocumentation> operation = new LinkedList<>();
  private List<XmlExtensionElementDocumentation> types = new LinkedList<>();

  @XmlElementWrapper(name = "connections")
  @XmlElement(name = "connection")
  public List<XmlExtensionElementDocumentation> getConnections() {
    return connections;
  }

  public void setConnections(List<XmlExtensionElementDocumentation> connections) {
    this.connections = connections;
  }

  @XmlElementWrapper(name = "configs")
  @XmlElement(name = "config")
  public List<XmlExtensionElementDocumentation> getConfigs() {
    return configs;
  }

  public void setConfigs(List<XmlExtensionElementDocumentation> configs) {
    this.configs = configs;
  }

  @XmlElementWrapper(name = "sources")
  @XmlElement(name = "source")
  public List<XmlExtensionElementDocumentation> getSources() {
    return sources;
  }

  public void setSources(List<XmlExtensionElementDocumentation> sources) {
    this.sources = sources;
  }

  @XmlElementWrapper(name = "operations")
  @XmlElement(name = "operation")
  public List<XmlExtensionElementDocumentation> getOperations() {
    return operation;
  }

  public void setOperation(List<XmlExtensionElementDocumentation> operation) {
    this.operation = operation;
  }

  @XmlElementWrapper(name = "types")
  @XmlElement(name = "type")
  public List<XmlExtensionElementDocumentation> getTypes() {
    return types;
  }

  public void setTypes(List<XmlExtensionElementDocumentation> types) {
    this.types = types;
  }

  @XmlElement
  public XmlExtensionElementDocumentation getExtension() {
    return extension;
  }

  public void setExtension(XmlExtensionElementDocumentation extension) {
    this.extension = extension;
  }
}
