/*
* Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
* The software in this package is published under the terms of the CPAL v1.0
* license, a copy of which has been included with this distribution in the
* LICENSE.txt file.
*/
package org.mule.extension.maven.loader;

import static java.lang.String.format;
import static java.nio.file.Files.newInputStream;
import static org.mule.extension.maven.ExtensionDescriptorMojo.descriptorPathOrFail;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

/**
 * Loader of an {@link MulePluginModel} for the Mule plugin artifact that is being processed.
 *
 * @since 1.0
 */
public class MulePluginJsonDescriberLoader {

  /**
   * Loads the {@code mule-artifact.json} file of the Mule Plugin project that is being processed.
   *
   * @throws MojoFailureException if the mule-artifact.json file can not be found or read.
   */
  public static MulePluginModel loadMulePluginDescriber(File outputDirectory) throws MojoFailureException {
    final Path path = descriptorPathOrFail(outputDirectory);
    return loadMulePluginModel(path);
  }

  private static MulePluginModel loadMulePluginModel(Path path) throws MojoFailureException {
    try (InputStream stream = newInputStream(path)) {
      return new MulePluginModelJsonSerializer().deserialize(IOUtils.toString(stream));
    } catch (IOException e) {
      throw new MojoFailureException(format("Could not read resource under [%s]", path), e);
    }
  }
}
