/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span.command;

import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;

public class FailsafeTriCommandExecutor<R, A, B, C> {
    private final Logger customLogger;
    private final String errorMessage;
    private final boolean propagateExceptions;
    private final R onFailReturnValue;

    public FailsafeTriCommandExecutor(Logger customLogger, String errorMessage, boolean propagateExceptions, R onFailReturnValue) {
        this.customLogger = customLogger;
        this.errorMessage = errorMessage;
        this.propagateExceptions = propagateExceptions;
        this.onFailReturnValue = onFailReturnValue;
    }

    public R execute(TriFunction<A, B, C, R> function, A firstParameter, B secondParameter, C thirdParameter) {
        try {
            return (R)function.apply(firstParameter, secondParameter, thirdParameter);
        }
        catch (Throwable e) {
            if (this.propagateExceptions) {
                throw e;
            }
            if (this.customLogger.isWarnEnabled()) {
                this.customLogger.warn(this.errorMessage, e);
            }
            return this.onFailReturnValue;
        }
    }
}

