/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.ast.api.exception.PropertyNotFoundException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.runtime.tracer.api.sniffer.SpanSnifferManager;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.api.span.validation.Assertion;
import org.mule.runtime.tracer.impl.CoreEventTracer;
import org.mule.runtime.tracer.impl.NoopCoreEventTracer;
import org.mule.runtime.tracer.impl.span.factory.EventSpanFactory;

public class SelectableCoreEventTracer
implements EventTracer<CoreEvent>,
Initialisable {
    private ObservabilitySignalConfiguration spanExporterConfiguration;
    private CoreEventTracer coreEventTracer;
    private static final EventTracer<CoreEvent> NOOP_CORE_EVENT_TRACER = NoopCoreEventTracer.getNoopCoreEventTracer();
    private EventTracer<CoreEvent> selectedCoreEventTracer = NOOP_CORE_EVENT_TRACER;
    private FeatureFlaggingService featureFlaggingService;
    private EventSpanFactory eventSpanFactory;

    public void initialise() throws InitialisationException {
        this.coreEventTracer = new CoreEventTracer(this.featureFlaggingService, this.eventSpanFactory);
        this.coreEventTracer.initialise();
        this.updateSelectedCoreEventTracer();
        this.spanExporterConfiguration.doOnConfigurationChanged(this::updateSelectedCoreEventTracer);
    }

    private synchronized void updateSelectedCoreEventTracer() {
        this.selectedCoreEventTracer = this.isTracingExportEnabled() ? this.coreEventTracer : NOOP_CORE_EVENT_TRACER;
    }

    private boolean isTracingExportEnabled() {
        try {
            return Boolean.parseBoolean(this.spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.enabled", "false"));
        }
        catch (PropertyNotFoundException e) {
            return false;
        }
    }

    public Optional<Span> startSpan(CoreEvent event, InitialSpanInfo spanInfo) {
        return this.selectedCoreEventTracer.startSpan((Event)event, spanInfo);
    }

    public Optional<Span> startSpan(CoreEvent event, InitialSpanInfo spanInfo, Assertion assertion) {
        return this.selectedCoreEventTracer.startSpan((Event)event, spanInfo, assertion);
    }

    public void endCurrentSpan(CoreEvent event) {
        this.selectedCoreEventTracer.endCurrentSpan((Event)event);
    }

    public void endCurrentSpan(CoreEvent event, Assertion condition) {
        this.selectedCoreEventTracer.endCurrentSpan((Event)event, condition);
    }

    public void injectDistributedTraceContext(EventContext eventContext, DistributedTraceContextGetter distributedTraceContextGetter) {
        this.selectedCoreEventTracer.injectDistributedTraceContext(eventContext, distributedTraceContextGetter);
    }

    public void recordErrorAtCurrentSpan(CoreEvent event, Supplier<Error> errorSupplier, boolean isErrorEscapingCurrentSpan) {
        this.selectedCoreEventTracer.recordErrorAtCurrentSpan((Event)event, errorSupplier, isErrorEscapingCurrentSpan);
    }

    public void setCurrentSpanName(CoreEvent event, String name) {
        this.selectedCoreEventTracer.setCurrentSpanName((Event)event, name);
    }

    public void addCurrentSpanAttribute(CoreEvent event, String key, String value) {
        this.selectedCoreEventTracer.addCurrentSpanAttribute((Event)event, key, value);
    }

    public void addCurrentSpanAttributes(CoreEvent event, Map<String, String> attributes) {
        this.selectedCoreEventTracer.addCurrentSpanAttributes((Event)event, attributes);
    }

    public void recordErrorAtCurrentSpan(CoreEvent event, boolean isErrorEscapingCurrentSpan) {
        this.selectedCoreEventTracer.recordErrorAtCurrentSpan((Event)event, isErrorEscapingCurrentSpan);
    }

    public Map<String, String> getDistributedTraceContextMap(CoreEvent event) {
        return this.selectedCoreEventTracer.getDistributedTraceContextMap((Event)event);
    }

    public SpanSnifferManager getSpanSnifferManager() {
        return this.selectedCoreEventTracer.getSpanSnifferManager();
    }

    @Inject
    @Named(value="_muleSpanExporterConfiguration")
    public void setSpanExporterConfiguration(ObservabilitySignalConfiguration spanExporterConfiguration) {
        this.spanExporterConfiguration = spanExporterConfiguration;
    }

    @Inject
    public void setEventSpanFactory(EventSpanFactory eventSpanFactory) {
        this.eventSpanFactory = eventSpanFactory;
    }

    @Inject
    public void setFeatureFlaggingService(FeatureFlaggingService featureFlaggingService) {
        this.featureFlaggingService = featureFlaggingService;
    }

    public EventTracer<CoreEvent> getSelectedCoreEventTracer() {
        return this.selectedCoreEventTracer;
    }
}

