/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl;

import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporter;
import org.mule.runtime.tracer.impl.span.InternalSpan;

public class OpenTelemetryTraceIdUtils {
    private static final Supplier<Random> randomSupplier = ThreadLocalRandom::current;
    private static final long INVALID_ID = 0L;
    private static final ThreadLocal<char[]> CHAR_ARRAY = new ThreadLocal();
    private static final String INVALID = "0000000000000000";
    private static final String ALPHABET = "0123456789abcdef";
    private static final int BYTES_LENGTH = 16;
    private static final int HEX_LENGTH = 32;
    static final int BYTE_BASE16 = 2;
    private static final char[] ENCODING = OpenTelemetryTraceIdUtils.buildEncodingArray();
    static final String TRACE_PARENT = "traceparent";
    private static final int HEX_LENGTH_SPAN_ID = 16;
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = 32;
    private static final int SPAN_ID_HEX_SIZE = 16;
    private static final int TRACE_OPTION_HEX_SIZE = 2;
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 36;
    private static final int TRACE_OPTION_OFFSET = 53;
    private static final int TRACEPARENT_HEADER_SIZE = 55;
    private static final Set<String> VALID_VERSIONS = new HashSet<String>();

    private OpenTelemetryTraceIdUtils() {
    }

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = ALPHABET.charAt(i >>> 4);
            encoding[i | 0x100] = ALPHABET.charAt(i & 0xF);
        }
        return encoding;
    }

    public static String fromLong(long id) {
        if (id == 0L) {
            return OpenTelemetryTraceIdUtils.getInvalid();
        }
        char[] result = OpenTelemetryTraceIdUtils.chars(16);
        OpenTelemetryTraceIdUtils.longToBase16String(id, result, 0);
        return new String(result, 0, 16);
    }

    public static void longToBase16String(long value, char[] dest, int destOffset) {
        OpenTelemetryTraceIdUtils.byteToBase16((byte)(value >> 56 & 0xFFL), dest, destOffset);
        OpenTelemetryTraceIdUtils.byteToBase16((byte)(value >> 48 & 0xFFL), dest, destOffset + 2);
        OpenTelemetryTraceIdUtils.byteToBase16((byte)(value >> 40 & 0xFFL), dest, destOffset + 4);
        OpenTelemetryTraceIdUtils.byteToBase16((byte)(value >> 32 & 0xFFL), dest, destOffset + 6);
        OpenTelemetryTraceIdUtils.byteToBase16((byte)(value >> 24 & 0xFFL), dest, destOffset + 8);
        OpenTelemetryTraceIdUtils.byteToBase16((byte)(value >> 16 & 0xFFL), dest, destOffset + 10);
        OpenTelemetryTraceIdUtils.byteToBase16((byte)(value >> 8 & 0xFFL), dest, destOffset + 12);
        OpenTelemetryTraceIdUtils.byteToBase16((byte)(value & 0xFFL), dest, destOffset + 14);
    }

    public static void byteToBase16(byte value, char[] dest, int destOffset) {
        int b = value & 0xFF;
        dest[destOffset] = ENCODING[b];
        dest[destOffset + 1] = ENCODING[b | 0x100];
    }

    public static char[] chars(int len) {
        char[] buffer = CHAR_ARRAY.get();
        if (buffer == null || buffer.length < len) {
            buffer = new char[len];
            CHAR_ARRAY.set(buffer);
        }
        return buffer;
    }

    public static String fromLongs(long traceIdLongHighPart, long traceIdLongLowPart) {
        if (traceIdLongHighPart == 0L && traceIdLongLowPart == 0L) {
            return OpenTelemetryTraceIdUtils.getInvalid();
        }
        char[] chars = OpenTelemetryTraceIdUtils.chars(32);
        OpenTelemetryTraceIdUtils.longToBase16String(traceIdLongHighPart, chars, 0);
        OpenTelemetryTraceIdUtils.longToBase16String(traceIdLongLowPart, chars, 16);
        return new String(chars, 0, 32);
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static String generateSpanId() {
        long id;
        Random random = randomSupplier.get();
        while ((id = random.nextLong()) == 0L) {
        }
        return OpenTelemetryTraceIdUtils.fromLong(id);
    }

    public static String generateTraceId(InternalSpan parentSpan) {
        long idLo;
        if (parentSpan != null && parentSpan.getIdentifier().isValid()) {
            return parentSpan.getIdentifier().getTraceId();
        }
        Random random = randomSupplier.get();
        long idHi = random.nextLong();
        while ((idLo = random.nextLong()) == 0L) {
        }
        return OpenTelemetryTraceIdUtils.fromLongs(idHi, idLo);
    }

    public static Map<String, String> getDistributedTraceContext(OpenTelemetrySpanExporter openTelemetrySpanExporter, boolean isAddMuleAncestorSpanId) {
        HashMap<String, String> context = new HashMap<String, String>();
        if (openTelemetrySpanExporter.getSpanId().equals(INVALID)) {
            return Collections.emptyMap();
        }
        char[] chars = OpenTelemetryTraceIdUtils.chars(55);
        chars[0] = VERSION.charAt(0);
        chars[1] = VERSION.charAt(1);
        chars[2] = 45;
        String traceId = openTelemetrySpanExporter.getTraceId();
        traceId.getChars(0, traceId.length(), chars, 3);
        chars[35] = 45;
        String spanId = openTelemetrySpanExporter.getSpanId();
        spanId.getChars(0, spanId.length(), chars, 36);
        chars[52] = 45;
        chars[53] = 48;
        chars[54] = 49;
        context.put(TRACE_PARENT, new String(chars, 0, 55));
        if (isAddMuleAncestorSpanId) {
            context.put("tracestate", W3CTraceContextEncoding.encodeTraceState((TraceState)openTelemetrySpanExporter.getTraceState().withAncestor(openTelemetrySpanExporter.getSpanId())));
        } else {
            context.put("tracestate", W3CTraceContextEncoding.encodeTraceState((TraceState)openTelemetrySpanExporter.getTraceState()));
        }
        return context;
    }

    public static SpanContext extractContextFromTraceParent(String traceparent) {
        boolean isValid;
        boolean bl = isValid = traceparent != null && (traceparent.length() == 55 || traceparent.length() > 55 && traceparent.charAt(55) == '-') && traceparent.charAt(2) == '-' && traceparent.charAt(35) == '-' && traceparent.charAt(52) == '-';
        if (!isValid) {
            return SpanContext.getInvalid();
        }
        String version = traceparent.substring(0, 2);
        if (!VALID_VERSIONS.contains(version)) {
            return SpanContext.getInvalid();
        }
        if (version.equals(VERSION) && traceparent.length() > 55) {
            return SpanContext.getInvalid();
        }
        String traceId = traceparent.substring(3, 3 + TraceId.getLength());
        String spanId = traceparent.substring(36, 36 + SpanId.getLength());
        char firstTraceFlagsChar = traceparent.charAt(53);
        char secondTraceFlagsChar = traceparent.charAt(54);
        if (OtelEncodingUtils.isValidBase16Character((char)firstTraceFlagsChar) && OtelEncodingUtils.isValidBase16Character((char)secondTraceFlagsChar)) {
            TraceFlags traceFlags = TraceFlags.fromByte((byte)OtelEncodingUtils.byteFromBase16((char)firstTraceFlagsChar, (char)secondTraceFlagsChar));
            return SpanContext.createFromRemoteParent((String)traceId, (String)spanId, (TraceFlags)traceFlags, (TraceState)TraceState.getDefault());
        }
        return SpanContext.getInvalid();
    }

    static {
        for (int i = 0; i < 255; ++i) {
            Object version = Long.toHexString(i);
            if (((String)version).length() < 2) {
                version = "0" + (String)version;
            }
            VALID_VERSIONS.add((String)version);
        }
    }
}

