/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryExportQueueMetrics
implements MetricExporter {
    private static final Logger METRICS_LOGGER = LoggerFactory.getLogger(OpenTelemetryExportQueueMetrics.class);
    public static final String PROCESSED_SPANS = "processedSpans";
    private Long loggedDroppedSpans = 0L;

    public CompletableResultCode export(Collection<MetricData> metrics) {
        metrics.forEach(metricData -> {
            if (metricData.getName().equals(PROCESSED_SPANS)) {
                this.checkForDroppedSpans((MetricData)metricData);
            }
        });
        return CompletableResultCode.ofSuccess();
    }

    private void checkForDroppedSpans(MetricData metricData) {
        this.logIfRelevant(this.getDroppedSpans(metricData));
    }

    private long getDroppedSpans(MetricData processesSpansMetricData) {
        PointData pointData = (PointData)processesSpansMetricData.getData().getPoints().iterator().next();
        if (Boolean.TRUE.equals(pointData.getAttributes().get(AttributeKey.booleanKey((String)"dropped")))) {
            return ((LongPointData)pointData).getValue();
        }
        return 0L;
    }

    private void logIfRelevant(long currentDroppedSpans) {
        if (currentDroppedSpans > this.loggedDroppedSpans) {
            METRICS_LOGGER.warn("Export queue overflow: {} spans have been dropped. Total spans dropped since the export started: {}", (Object)(currentDroppedSpans - this.loggedDroppedSpans), (Object)currentDroppedSpans);
            this.loggedDroppedSpans = currentDroppedSpans;
        }
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }
}

