/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl.optel.resources;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporterUtils;
import org.mule.runtime.tracer.exporter.impl.config.type.OpenTelemetryExporterTransport;
import org.mule.runtime.tracer.exporter.impl.metrics.OpenTelemetryExportQueueMetrics;
import org.mule.runtime.tracer.exporter.impl.optel.resources.SpanExporterConfiguratorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryResources {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryResources.class);
    private static final ContextPropagators PROPAGATOR = ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance());
    public static final AttributeKey<String> SERVICE_NAME_KEY = AttributeKey.stringKey((String)"service.name");
    public static final AttributeKey<String> SERVICE_NAMESPACE_KEY = AttributeKey.stringKey((String)"service.namespace");

    private OpenTelemetryResources() {
    }

    private static SdkMeterProvider getMeterProvider(ObservabilitySignalConfiguration spanExporterConfiguration) {
        PeriodicMetricReader periodicReader = PeriodicMetricReader.builder((MetricExporter)new OpenTelemetryExportQueueMetrics()).setInterval(Duration.ofMillis(Long.parseLong(spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.metricsLogFrequency")))).build();
        return SdkMeterProvider.builder().registerMetricReader((MetricReader)periodicReader).build();
    }

    public static Resource getResource(String serviceName, ObservabilitySignalConfiguration configuration) {
        return Resource.getDefault().merge(Resource.create((Attributes)Attributes.of(SERVICE_NAME_KEY, (Object)configuration.getStringValue("mule.openTelemetry.tracer.exporter.resource.service.name", serviceName), SERVICE_NAMESPACE_KEY, (Object)configuration.getStringValue("mule.openTelemetry.tracer.exporter.resource.service.namespace"))));
    }

    public static ContextPropagators getPropagator() {
        return PROPAGATOR;
    }

    public static SpanProcessor resolveOpenTelemetrySpanProcessor(ObservabilitySignalConfiguration spanExporterConfiguration, ObservabilitySignalConfiguration privilegedSpanExporterConfiguration, SpanExporter spanExporter) throws SpanExporterConfiguratorException {
        LOGGER.debug("Mule Open Telemetry Tracer Exporter Endpoint is {}", (Object)spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.endpoint"));
        LOGGER.debug("Mule Open Telemetry Tracer Exporter Protocol Type is {}", (Object)spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.type"));
        int maxBatchSize = Integer.parseInt(spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.batch.maxSize"));
        if (maxBatchSize < 512) {
            throw new SpanExporterConfiguratorException("The batch max size cannot be lower than 512");
        }
        int batchQueueSize = Integer.parseInt(spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.batch.queueSize"));
        return BatchSpanProcessor.builder((SpanExporter)spanExporter).setMaxQueueSize(batchQueueSize).setMeterProvider((MeterProvider)OpenTelemetryResources.getMeterProvider(spanExporterConfiguration)).setScheduleDelay(Long.parseLong(privilegedSpanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.batch.scheduledDelay")), TimeUnit.MILLISECONDS).setMaxExportBatchSize(maxBatchSize).build();
    }

    public static SpanExporter resolveOpenTelemetrySpanExporter(ObservabilitySignalConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        String type = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.type");
        if (type == null) {
            throw new SpanExporterConfiguratorException("A type for span export was not created");
        }
        try {
            return OpenTelemetryExporterTransport.valueOf(type).getSpanExporterConfigurator().configExporter(spanExporterConfiguration);
        }
        catch (Exception e) {
            throw new SpanExporterConfiguratorException(e);
        }
    }

    public static Sampler getSampler(ObservabilitySignalConfiguration spanExporterConfiguration) {
        return OpenTelemetrySpanExporterUtils.getSampler(spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.sampler.type"), spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.sampler.arg"));
    }

    public static class NoOpSpanExporter
    implements SpanExporter {
        public static SpanExporter getInstance() {
            return new NoOpSpanExporter();
        }

        private NoOpSpanExporter() {
        }

        public CompletableResultCode export(Collection<SpanData> collection) {
            return new CompletableResultCode().succeed();
        }

        public CompletableResultCode flush() {
            return new CompletableResultCode().succeed();
        }

        public CompletableResultCode shutdown() {
            return new CompletableResultCode().succeed();
        }
    }
}

