/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl.optel.resources.http;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.tracer.exporter.impl.config.SpanExporterConfigurationUtils;
import org.mule.runtime.tracer.exporter.impl.optel.resources.SpanExporterConfigurator;
import org.mule.runtime.tracer.exporter.impl.optel.resources.SpanExporterConfiguratorException;

public class HttpSpanExporterConfigurator
implements SpanExporterConfigurator {
    @Override
    public SpanExporter configExporter(ObservabilitySignalConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        String timeout;
        String headers;
        String type;
        String endpoint = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.endpoint");
        OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder();
        if (!StringUtils.isEmpty((CharSequence)endpoint)) {
            builder.setEndpoint(endpoint);
        }
        if ((type = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.compression")) != null) {
            builder.setCompression(type);
        }
        if (spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.tls.enabled", "false").equals(Boolean.TRUE.toString())) {
            this.configureTls(builder, spanExporterConfiguration);
        }
        if ((headers = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.headers")) != null) {
            this.configureHeaders(builder, headers);
        }
        if ((timeout = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.timeout")) != null) {
            this.configureTimeout(builder, timeout);
        }
        SpanExporterConfigurationUtils.enableBackoffStrategy(builder, spanExporterConfiguration);
        return builder.build();
    }

    private void configureTimeout(OtlpHttpSpanExporterBuilder builder, String timeout) {
        builder.setTimeout(Long.parseLong(timeout), TimeUnit.MILLISECONDS);
    }

    private void configureHeaders(OtlpHttpSpanExporterBuilder builder, String headers) throws SpanExporterConfiguratorException {
        try {
            Map retMap = (Map)new Gson().fromJson(headers, new TypeToken<HashMap<String, Object>>(){}.getType());
            retMap.forEach((arg_0, arg_1) -> ((OtlpHttpSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
        }
        catch (Exception e) {
            throw new SpanExporterConfiguratorException(e);
        }
    }

    private void configureTls(OtlpHttpSpanExporterBuilder builder, ObservabilitySignalConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        HttpSpanExporterConfigurator.configureTrustedCertificates(builder, spanExporterConfiguration);
        this.configureClientTls(builder, spanExporterConfiguration);
    }

    private static void configureTrustedCertificates(OtlpHttpSpanExporterBuilder builder, ObservabilitySignalConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        String caFilePath = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.tls.caFileLocation");
        if (caFilePath != null) {
            try {
                byte[] caFileBytes = Files.readAllBytes(Paths.get(caFilePath, new String[0]));
                builder.setTrustedCertificates(caFileBytes);
            }
            catch (IOException e) {
                throw new SpanExporterConfiguratorException(e);
            }
        }
    }

    private void configureClientTls(OtlpHttpSpanExporterBuilder builder, ObservabilitySignalConfiguration spanExporterConfiguration) throws SpanExporterConfiguratorException {
        String certFilePath = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exportertls.certFileLocation");
        String keyFilePath = spanExporterConfiguration.getStringValue("mule.openTelemetry.tracer.exporter.tls.keyFileLocation");
        if (certFilePath != null && keyFilePath != null) {
            try {
                byte[] keyFileBytes = Files.readAllBytes(Paths.get(keyFilePath, new String[0]));
                byte[] certFileBytes = Files.readAllBytes(Paths.get(certFilePath, new String[0]));
                builder.setClientTls(keyFileBytes, certFileBytes);
            }
            catch (IOException e) {
                throw new SpanExporterConfiguratorException(e);
            }
        }
    }
}

