/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.config.impl;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.observability.AbstractFileObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilityConfigurationFileWatcher;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSpanExporterConfiguration
extends AbstractFileObservabilitySignalConfiguration
implements ObservabilitySignalConfiguration,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(FileSpanExporterConfiguration.class);
    private final String configurationFileName = System.getProperty("mule.openTelemetry.tracer.exporter.configurationFileName", "tracer-exporter.conf");
    private final CompositeRunnable doOnConfigurationChanged = new CompositeRunnable();
    private ObservabilityConfigurationFileWatcher tracingConfigurationFileWatcher;
    private Path resolvedConfigurationFilePath;
    private boolean tracingConfigurationFileWatcherInitialised;
    private final String artifactId;

    public FileSpanExporterConfiguration(MuleContext muleContext) {
        super(path -> FileSpanExporterConfiguration.findArtifactConfigFile((ClassLoader)muleContext.getExecutionClassLoader(), (String)path), propertyReference -> new DefaultConfigurationPropertiesResolver(Optional.empty(), (ConfigurationPropertiesProvider)new SystemPropertiesConfigurationProvider()).apply(propertyReference));
        this.artifactId = muleContext.getId();
    }

    protected Path getSignalConfigurationFileDirectoryPath() {
        if (this.resolvedConfigurationFilePath != null) {
            return this.resolvedConfigurationFilePath;
        }
        this.resolvedConfigurationFilePath = Paths.get(System.getProperty("mule.openTelemetry.tracer.exporter.configurationFilePath", MuleFoldersUtil.getConfFolder().getAbsolutePath()), new String[0]).toAbsolutePath();
        return this.resolvedConfigurationFilePath;
    }

    protected String getSignalConfigurationFileName() {
        return this.configurationFileName;
    }

    protected void initialise() {
        super.initialise();
        if (this.getConfigurationFile() != null && this.getConfigurationFile().exists() && !this.tracingConfigurationFileWatcherInitialised) {
            this.tracingConfigurationFileWatcher = new ObservabilityConfigurationFileWatcher(this.getConfigurationFile(), (Runnable)this.doOnConfigurationChanged);
            this.tracingConfigurationFileWatcher.start();
            this.tracingConfigurationFileWatcherInitialised = true;
        }
    }

    protected void onConfigurationFileNotFound() {
        logger.atInfo().log("Tracing exporter configuration file named '{}' not found {}. Using default configuration.", (Object)this.getSignalConfigurationFileName(), (Object)this.getConfigurationFileLocations());
    }

    private String getConfigurationFileLocations() {
        if (FileSpanExporterConfiguration.isApplicationLevelConfigurable()) {
            return String.format("at at both '%s' artifact resources and the '%s' configuration path", this.artifactId, this.getSignalConfigurationFileDirectoryPath());
        }
        return String.format("at the '%s' configuration path", this.getSignalConfigurationFileDirectoryPath());
    }

    protected void onConfigurationFileLoadError(Exception error, File configurationFile) {
        logger.atWarn().log("Span exporter configuration file at '{}' had a parsing error: {}. Using default configuration.", (Object)configurationFile.getAbsolutePath(), (Object)error.getMessage());
    }

    public void doOnConfigurationChanged(Runnable doOnConfigurationChanged) {
        this.doOnConfigurationChanged.addRunnable(doOnConfigurationChanged);
    }

    public void dispose() {
        if (this.tracingConfigurationFileWatcher != null) {
            this.tracingConfigurationFileWatcher.interrupt();
        }
    }

    private class CompositeRunnable
    implements Runnable {
        private final List<Runnable> runnables = new ArrayList<Runnable>();

        CompositeRunnable() {
            this.runnables.add(FileSpanExporterConfiguration.this::initialise);
        }

        @Override
        public void run() {
            this.runnables.forEach(Runnable::run);
        }

        public void addRunnable(Runnable runnable) {
            this.runnables.add(runnable);
        }
    }
}

