/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.message.request;

import java.net.URI;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.BaseHttpMessage;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

class DefaultHttpRequest
extends BaseHttpMessage
implements HttpRequest {
    private final URI uri;
    private final String path;
    private final HttpProtocol protocol;
    private final String method;
    private final MultiMap<String, String> queryParams;
    private final HttpEntity entity;

    DefaultHttpRequest(URI uri, String path, String method, HttpProtocol protocol, MultiMap<String, String> headers, MultiMap<String, String> queryParams, HttpEntity entity) {
        super(headers);
        this.uri = uri;
        this.path = path;
        this.protocol = protocol;
        this.method = method;
        this.queryParams = queryParams;
        this.entity = entity;
    }

    @Override
    public HttpProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public MultiMap<String, String> getQueryParams() {
        return this.queryParams.toImmutableMultiMap();
    }

    public String toString() {
        return "DefaultHttpRequest {" + System.lineSeparator() + "  uri: " + this.uri.toString() + "," + System.lineSeparator() + "  path: " + this.path + "," + System.lineSeparator() + "  method: " + this.method + "," + System.lineSeparator() + "  headers: " + this.headers.toString() + "," + System.lineSeparator() + "  queryParams: " + this.queryParams.toString() + System.lineSeparator() + "}";
    }
}

