/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.api.domain;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParameterMap
implements Map<String, String>,
Serializable {
    protected Map<String, LinkedList<String>> paramsMap;

    public ParameterMap(Map parametersMap) {
        this.paramsMap = new HashMap<String, LinkedList<String>>();
        parametersMap.forEach((key, value) -> {
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                values.stream().forEach((? super T collectionValue) -> this.put(key.toString(), collectionValue != null ? collectionValue.toString() : null));
            } else {
                this.put(key.toString(), value.toString());
            }
        });
        this.paramsMap = Collections.unmodifiableMap(this.paramsMap);
    }

    public ParameterMap() {
        this.paramsMap = new LinkedHashMap<String, LinkedList<String>>();
    }

    public ParameterMap toImmutableParameterMap() {
        return new ParameterMap(this.paramsMap);
    }

    @Override
    public int size() {
        return this.paramsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.paramsMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.paramsMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.paramsMap.containsValue(value);
    }

    @Override
    public String get(Object key) {
        LinkedList<String> value = this.paramsMap.get(key);
        if (value != null) {
            LinkedList<String> values = value;
            return values.getLast();
        }
        return null;
    }

    public List<String> getAll(String key) {
        return this.paramsMap.containsKey(key) ? Collections.unmodifiableList((List)this.paramsMap.get(key)) : Collections.emptyList();
    }

    @Override
    public String put(String key, String value) {
        LinkedList<String> previousValue = this.paramsMap.get(key);
        LinkedList<String> newValue = previousValue;
        if (previousValue != null) {
            previousValue = new LinkedList<String>(previousValue);
        } else {
            newValue = new LinkedList();
        }
        newValue.add(value);
        this.paramsMap.put(key, newValue);
        if (previousValue == null || previousValue.isEmpty()) {
            return null;
        }
        return previousValue.getFirst();
    }

    @Override
    public void put(String key, Collection<String> values) {
        LinkedList<String> newValue = this.paramsMap.get(key);
        if (newValue == null) {
            newValue = new LinkedList();
        }
        newValue.addAll(values);
        this.paramsMap.put(key, newValue);
    }

    @Override
    public String remove(Object key) {
        Collection values = this.paramsMap.remove(key);
        if (values != null) {
            return (String)values.iterator().next();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> aMap) {
        for (String string : aMap.keySet()) {
            LinkedList<String> values = new LinkedList<String>();
            values.add(aMap.get(string));
            this.paramsMap.put(string, values);
        }
    }

    @Override
    public void clear() {
        this.paramsMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.paramsMap.keySet();
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> values = new ArrayList<String>();
        for (String key : this.paramsMap.keySet()) {
            values.add(this.paramsMap.get(key).getLast());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
        for (String key : this.paramsMap.keySet()) {
            entries.add(new AbstractMap.SimpleEntry<String, String>(key, this.paramsMap.get(key).getLast()));
        }
        return entries;
    }

    @Override
    public boolean equals(Object o) {
        return this.paramsMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.paramsMap.hashCode();
    }

    public Map<String, ? extends List<String>> toListValuesMap() {
        return Collections.unmodifiableMap(this.paramsMap);
    }

    public String toString() {
        return "ParameterMap{" + Arrays.toString(this.paramsMap.entrySet().toArray()) + '}';
    }
}

