/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation.test;

import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.input.ReaderInputStream;
import org.junit.Before;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.extension.ComponentConfigurerTestUtils;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.api.metadata.ComponentMetadataConfigurerFactory;

public abstract class AbstractCoreValidationTestCase {
    protected static AstXmlParser parser;

    @Before
    public void createAstXmlParser() {
        if (parser != null) {
            return;
        }
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(AbstractCoreValidationTestCase.class.getClassLoader());
        ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer().named("test").describedAs("test").onVersion("1.0.0").fromVendor("MuleSoft, Inc.").withCategory(Category.COMMUNITY).withModelProperty((ModelProperty)new CustomBuildingDefinitionProviderModelProperty()).withXmlDsl(XmlDslModel.builder().setPrefix("test").setNamespace(String.format("http://www.mulesoft.org/schema/mule/%s", "test")).setSchemaVersion("1.0.0").setXsdFileName("test.xsd").setSchemaLocation(String.format("%s/%s/%s.xsd", String.format("http://www.mulesoft.org/schema/mule/%s", "test"), "current", "test")).build());
        ConfigurationDeclarer config = extensionDeclarer.withConfig("config");
        ConfigurationDeclarer otherConfig = extensionDeclarer.withConfig("otherConfig");
        otherConfig.onDefaultParameterGroup().withRequiredParameter("count").ofType(ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MuleExtensionModelProvider.class.getClassLoader()).load(Integer.class));
        OperationDeclarer operation = extensionDeclarer.withOperation("operation");
        operation.withOutput().ofType(typeLoader.load(Void.TYPE));
        operation.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        parser = AstXmlParser.builder().withExtensionModels(this.resolveRuntimeExtensionModels()).withExtensionModel(new ExtensionModelLoader(){

            public String getId() {
                return AbstractCoreValidationTestCase.class.getName();
            }

            protected void declareExtension(ExtensionLoadingContext context) {
            }
        }.loadExtensionModel(extensionDeclarer, ExtensionModelLoadingRequest.builder((ClassLoader)AbstractCoreValidationTestCase.class.getClassLoader(), (DslResolvingContext)DslResolvingContext.nullDslResolvingContext()).build())).withSchemaValidationsDisabled().build();
    }

    protected List<ExtensionModel> resolveRuntimeExtensionModels() {
        MuleExtensionModelProvider.setConfigurerFactory((ComponentMetadataConfigurerFactory)ComponentConfigurerTestUtils.createMockedFactory());
        return Arrays.asList(MuleExtensionModelProvider.getExtensionModel());
    }

    protected List<ValidationResultItem> runValidation(String ... xmlConfigs) {
        ArrayList<Pair> configs = new ArrayList<Pair>();
        for (int i = 0; i < xmlConfigs.length; ++i) {
            configs.add(new Pair((Object)("test" + i), (Object)new ReaderInputStream((Reader)new StringReader(xmlConfigs[i]), StandardCharsets.UTF_8)));
        }
        ArtifactAst ast = parser.parse(configs);
        return MuleAstUtils.recursiveStreamWithHierarchy((ArtifactAst)ast).filter(c -> this.getValidation().applicable().test(ImmutableList.builder().addAll((Iterable)c.getSecond()).add((Object)((ComponentAst)c.getFirst())).build())).flatMap(c -> this.getValidation().validateMany((ComponentAst)c.getFirst(), ast).stream()).collect(Collectors.toList());
    }

    protected abstract Validation getValidation();
}

