/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class ErrorMappingTargetTypeReferencesDoNotUseExtensionNamespace
extends AbstractErrorTypesValidation {
    public ErrorMappingTargetTypeReferencesDoNotUseExtensionNamespace(Optional<FeatureFlaggingService> featureFlaggingService) {
        super(featureFlaggingService);
    }

    public String getName() {
        return "Target error type doesn't use extension namespaces";
    }

    public String getDescription() {
        return "Target error type doesn't use extension namespaces.";
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(AbstractErrorTypesValidation::errorMappingPresent);
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        Set<String> alreadyUsedErrorNamespaces = ErrorMappingTargetTypeReferencesDoNotUseExtensionNamespace.getAlreadyUsedErrorNamespaces(artifact);
        ComponentParameterAst mappingsParameter = component.getParameter("Error Mappings", "errorMappings");
        List errorMappings = (List)mappingsParameter.getValue().getRight();
        for (ErrorMapping errorMapping : errorMappings) {
            String errorTypeString = errorMapping.getTarget();
            ComponentIdentifier errorTypeId = ErrorMappingTargetTypeReferencesDoNotUseExtensionNamespace.parseErrorType(errorTypeString);
            String namespace = errorTypeId.getNamespace();
            if (!alreadyUsedErrorNamespaces.contains(namespace) || ErrorMappingTargetTypeReferencesDoNotUseExtensionNamespace.isAllowedBorrowedNamespace(namespace)) continue;
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)mappingsParameter, (Validation)this, (String)String.format("Cannot use error type '%s': namespace already exists.", errorTypeString)));
        }
        return Optional.empty();
    }
}

