/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.extension;

import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.config.internal.dsl.processor.xml.OperationDslNamespaceInfoProvider;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;
import org.mule.sdk.api.stereotype.MuleStereotypes;

class MuleOperationExtensionModelDeclarer {
    private static final String TYPE_EXAMPLE = "string or number or http:request-config";
    private static final MetadataType EXPRESSION_SUPPORT_TYPE = MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"SUPPORTED", "NOT_SUPPORTED", "REQUIRED"}).build();

    MuleOperationExtensionModelDeclarer() {
    }

    ExtensionDeclarer declareExtensionModel() {
        ExtensionDeclarer declarer = new ExtensionDeclarer().named("Mule Operations DSL").describedAs("DSL for declaring Mule Operation").onVersion(MuleExtensionModelProvider.MULE_VERSION).fromVendor("MuleSoft, Inc.").withCategory(Category.COMMUNITY).withModelProperty((ModelProperty)new CustomBuildingDefinitionProviderModelProperty()).withXmlDsl(XmlDslModel.builder().setPrefix("operation").setNamespace(OperationDslNamespaceInfoProvider.OPERATION_DSL_NAMESPACE_URI).setSchemaVersion(MuleExtensionModelProvider.MULE_VERSION).setXsdFileName("mule-operation.xsd").setSchemaLocation("operation/current/mule-operation.xsd").build());
        this.declareOperationDef(declarer);
        return declarer;
    }

    private void declareOperationDef(ExtensionDeclarer declarer) {
        ConstructDeclarer def = (ConstructDeclarer)((ConstructDeclarer)declarer.withConstruct("def").describedAs("Defines an operation")).allowingTopLevelDefinition().withStereotype(MuleStereotypes.OPERATION_DEF_STEREOTYPE);
        ParameterGroupDeclarer parameters = def.onDefaultParameterGroup();
        parameters.withRequiredParameter("name").describedAs("The operation's name").withDisplayModel(DisplayModel.builder().displayName("Operation name").summary("The operation's name").build()).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).ofType(MuleExtensionModelProvider.STRING_TYPE).asComponentId();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameters.withOptionalParameter("description").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("Detailed description of the operation purpose and behavior")).withDisplayModel(DisplayModel.builder().displayName("Description").summary("Detailed description of the operation purpose and behavior").build())).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withLayout(LayoutModel.builder().asText().build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameters.withOptionalParameter("summary").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("A brief description of the operation")).withDisplayModel(DisplayModel.builder().displayName("Summary").summary("A brief description of the operation").build())).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameters.withOptionalParameter("displayName").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("The operation's name in the GUI")).withDisplayModel(DisplayModel.builder().displayName("Display Name").summary("The operation's name in the GUI").build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameters.withOptionalParameter("visibility").ofType((MetadataType)MuleExtensionModelProvider.BASE_TYPE_BUILDER.stringType().enumOf(new String[]{"PUBLIC", "PRIVATE"}).build())).describedAs("The operation visibility to third parties")).withDisplayModel(DisplayModel.builder().displayName("Visibility").summary("The operation visibility to third parties").build());
        this.addParametersDeclaration(def);
        this.declareOutputConstruct(def);
        this.declareDeprecationConstruct((ComponentDeclarer)def, "Defines an operation's deprecation.");
        ((NestedChainDeclarer)def.withChain("body").describedAs("The operations that makes for the operation's implementation")).setRequired(true);
    }

    private void declareOutputConstruct(ConstructDeclarer def) {
        NestedComponentDeclarer outputConstruct = def.withComponent("output").describedAs("Defines a operation's output types.").withStereotype(MuleStereotypes.OUTPUT_STEREOTYPE).withMinOccurs(1).withMaxOccurs(Integer.valueOf(1));
        NestedComponentDeclarer payloadType = outputConstruct.withComponent("payload-type").describedAs("Type definition for the operation's output payload").withStereotype(MuleStereotypes.OUTPUT_PAYLOAD_STEREOTYPE).withMinOccurs(1).withMaxOccurs(Integer.valueOf(1));
        this.declareOutputTypeParameters(payloadType, "payload");
        NestedComponentDeclarer attributesType = outputConstruct.withOptionalComponent("attributes-type").describedAs("Type definition for the operation's output attributes").withStereotype(MuleStereotypes.OUTPUT_ATTRIBUTES_STEREOTYPE).withMinOccurs(0).withMaxOccurs(Integer.valueOf(1));
        this.declareOutputTypeParameters(attributesType, "attributes");
    }

    private void declareDeprecationConstruct(ComponentDeclarer def, String description) {
        NestedComponentDeclarer deprecationConstruct = def.withComponent("deprecated").describedAs(description).withStereotype(MuleStereotypes.DEPRECATED_STEREOTYPE).withMinOccurs(0).withMaxOccurs(Integer.valueOf(1));
        ParameterGroupDeclarer defaultParameterGroupDeclarer = deprecationConstruct.onDefaultParameterGroup();
        defaultParameterGroupDeclarer.withRequiredParameter("message").describedAs("Describes why something was deprecated, what can be used as substitute, or both").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        defaultParameterGroupDeclarer.withRequiredParameter("since").describedAs("The version of the extension in which the annotated member was deprecated").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)defaultParameterGroupDeclarer.withOptionalParameter("toRemoveIn").describedAs("The version of the extension in which the annotated member will be removed or was removed")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private void declareOutputTypeParameters(NestedComponentDeclarer component, String outputRole) {
        component.onDefaultParameterGroup().withRequiredParameter("type").describedAs("The output " + outputRole + " type").withDisplayModel(DisplayModel.builder().displayName(StringUtils.capitalize((String)outputRole) + " type").summary("The output " + outputRole + " type").example(TYPE_EXAMPLE).build()).ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private DisplayModel display(String displayName, String summary) {
        return DisplayModel.builder().displayName(displayName).summary(summary).build();
    }

    private DisplayModel display(String displayName, String summary, String example) {
        return DisplayModel.builder().displayName(displayName).summary(summary).example(example).build();
    }

    private void addParametersDeclaration(ConstructDeclarer def) {
        NestedComponentDeclarer parametersDef = def.withOptionalComponent("parameters").describedAs("The operation's parameters").withMinOccurs(0).withMaxOccurs(Integer.valueOf(1));
        NestedComponentDeclarer parameterDef = parametersDef.withComponent("parameter").describedAs("Defines an operation parameter").withMinOccurs(1).withMaxOccurs(null);
        this.declareDeprecationConstruct((ComponentDeclarer)parameterDef, "Defines a parameter's deprecation.");
        ParameterGroupDeclarer parameterDefParameters = parameterDef.onDefaultParameterGroup();
        this.addParameterDeclaration(parameterDefParameters);
        NestedComponentDeclarer optionalParameterDef = parametersDef.withOptionalComponent("optional-parameter").describedAs("Defines an optional operation parameter").withMinOccurs(0).withMaxOccurs(null);
        ParameterGroupDeclarer optionalParameterDefParameters = optionalParameterDef.onDefaultParameterGroup();
        this.addOptionalParameterDeclaration(optionalParameterDefParameters);
        NestedComponentDeclarer exclusiveOptionalDef = parametersDef.withOptionalComponent("exclusive-optionals").describedAs("Defines a set of mutually exclusive parameters").withMinOccurs(0).withMaxOccurs(Integer.valueOf(1));
        exclusiveOptionalDef.onDefaultParameterGroup().withRequiredParameter("exclusiveOptionals").describedAs("Comma separated list of parameters that are mutually exclusive").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withDisplayModel(this.display("Parameters", "Comma separated list of parameters that this element is optional against"));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)exclusiveOptionalDef.onDefaultParameterGroup().withOptionalParameter("oneRequired").describedAs("Enforces that one of the parameters must be set at any given time")).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withDisplayModel(this.display("One required?", "Enforces that one of the parameters must be set at any given time"));
    }

    private void addParameterDeclaration(ParameterGroupDeclarer<?> parameterGroupDeclarer) {
        parameterGroupDeclarer.withRequiredParameter("name").describedAs("The parameter's name").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).withDisplayModel(this.display("Parameter name", "The parameter's name"));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("description").describedAs("Detailed description of the parameter, it's semantics, usage and effects")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(this.display("Parameter description", "Detailed description of the parameter, it's semantics, usage and effects"))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withLayout(LayoutModel.builder().asText().build());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("summary").describedAs("A brief description of the parameter")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(this.display("Summary", "A brief description of the parameter"))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("type").describedAs("The parameter's type")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withDisplayModel(this.display("Parameter type", "The Parameter's type", TYPE_EXAMPLE))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("expressionSupport").describedAs("The support level this parameter offers regarding expressions")).ofType(EXPRESSION_SUPPORT_TYPE)).defaultingTo((Object)org.mule.sdk.api.meta.ExpressionSupport.SUPPORTED.name()).withDisplayModel(this.display("Expression Support", "The support level this parameter offers regarding expressions"))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("configOverride").describedAs("Whether the parameter should act as a Config Override.")).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)"false").withDisplayModel(this.display("Config Override", "Whether the parameter should act as a Config Override."))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private void addOptionalParameterDeclaration(ParameterGroupDeclarer<?> parameterGroupDeclarer) {
        this.addParameterDeclaration(parameterGroupDeclarer);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)parameterGroupDeclarer.withOptionalParameter("defaultValue").describedAs("The parameter's default value if not provided.")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withDisplayModel(this.display("Optional", "The parameter's default value if not provided."));
    }
}

